package util

import (
	"fmt"
	"os"
	"strconv"
	"strings"
)

// WritePID 将 pid 写入文件。
func WritePID(path string, pid int) error {
	data := []byte(fmt.Sprintf("%d\n", pid))
	return AtomicWriteFile(path, data, 0o644)
}

// ReadPID 读取 PID 文件。
func ReadPID(path string) (int, error) {
	data, err := os.ReadFile(path)
	if err != nil {
		return 0, err
	}
	value := strings.TrimSpace(string(data))
	pid, err := strconv.Atoi(value)
	if err != nil {
		return 0, fmt.Errorf("无效的 PID 值: %q", value)
	}
	return pid, nil
}
