package autostart

import (
	"context"

	"frpc-tool/internal/util"
)

// Manager 定义跨平台自启操作。
type Manager interface {
	Kind() util.AutostartKind
	IsInstalled(ctx context.Context) (bool, error)
	Enable(ctx context.Context) error
	Disable(ctx context.Context) error
	Start(ctx context.Context) error
	Stop(ctx context.Context) error
	Restart(ctx context.Context) error
	Status(ctx context.Context) (string, error)
}

// NewManager 根据环境返回合适的自启管理器；若不支持则返回 nil。
func NewManager(env util.Environment) Manager {
	switch env.AutostartKind {
	case util.AutostartLaunchd:
		return newLaunchdManager(env)
	default:
		return nil
	}
}
