# frpc-tool

一个跨平台的 FRP 客户端（frpc）管理工具，支持：

- 自动从 GitHub 获取并更新最新的 `frpc` 二进制；
- 使用本地模板或远程 URL 部署 `frpc.toml` 配置；
- 启动、停止、重启以及查看运行状态；
- 安装/卸载自启服务：Linux(systemd)、macOS(launchd)、Windows(sc.exe)；
- 交互式终端菜单，快速完成常用操作。

## 快速开始

```bash
go build ./cmd/frpc-tool
./frpc-tool          # 默认进入交互菜单
```

非交互模式可以通过命令行参数完成相同功能：

```bash
./frpc-tool -update-binary
./frpc-tool -deploy-config -config-source https://example.com/frpc.toml
./frpc-tool -start
```

默认会在当前目录下创建 `./frpc/` 目录，内部包含：

- `frpc` / `frpc.exe`：自动下载的可执行文件；
- `frpc.toml`：配置文件；
- `frpc.log`、`frpc.pid`：前台运行时的日志与 PID 文件。

> 自启功能需要相应平台支持：
> - Linux：要求 `systemctl --user` 可用；
> - macOS：写入 `~/Library/LaunchAgents/com.frpc.client.plist`；
> - Windows：需要以管理员权限运行以便创建服务。

## 环境变量

- `GITHUB_TOKEN`：若命中 GitHub API 频率限制，可设置个人访问令牌以提升配额。

## 注意事项

- 在启动前，请确保配置文件中的地址、端口、令牌等信息正确；
- 远程配置支持 `http(s)://`，下载失败会保留本地配置；
- 若选择前台运行模式，可在 `./frpc/frpc.log` 中查看日志输出。
