# Repository Guidelines

## 项目结构与模块组织
仓库遵循 Go 模块化布局：`cmd/frpc-tool` 提供 CLI 入口与参数解析，`internal/menu` 负责交互菜单与命令行处理，`internal/install` 内嵌 macOS arm64 版 `frpc` 并负责写出安装，`internal/config`、`internal/runner`、`internal/autostart`（launchd 专用）与 `internal/util` 分别覆盖配置部署、运行控制、自启管理与通用工具。运行时会在当前目录生成 `frpc/` 目录（可执行文件、`frpc.toml`、日志与 PID），提交前请排除这些生成文件。

## 构建、测试与开发命令
使用 Go 1.25：`go env GOPATH` 校验环境后，执行 `go build ./cmd/frpc-tool` 生成二进制；开发时可通过 `go run ./cmd/frpc-tool --help` 快速验证参数；统一使用 `go test ./...` 与 `go test -cover ./...` 运行与统计测试。

## 代码风格与命名约定
保持默认 Gofmt 风格（制表符缩进、K&R 花括号），保存前运行 `go fmt ./...` 与 `goimports`。包名保持小写单词并聚焦单一职责；导出类型与函数使用驼峰动词-名词组合，如 `StartService`；错误变量使用 `err` 或 `ErrXxx`，常量命名 `const` + 大写单词。新增模块应放入 `internal/` 并确保 API 简洁，不引入未使用的预留逻辑，以满足 KISS 与 YAGNI。

## 测试规范
首选 Go 标准库 `testing`，编写表驱动用例与 `t.Helper()` 辅助函数，命名遵循 `Test功能_场景`。覆盖关键路径（内置安装、模板渲染、服务控制）；新增公共函数必须提供单元测试，目标覆盖率保持≥70%。集成测试可借助临时目录模拟 `frpc/` 结构，确保不污染真实配置。

## 提交与拉取请求指南
当前目录未发现 Git 历史，建议采用 Conventional Commits（如 `feat: add launchd installer`）保持可读性。提交前运行全部构建与测试命令，并清理生成物。拉取请求需包含：问题背景、方案说明、验证步骤（含命令输出要点）及潜在风险；若涉及系统服务或远程下载逻辑，请附平台差异说明与手动验证记录。

## 配置与安全提示
不要将真实隧道凭据、访问令牌写入仓库；示例配置放置于 `internal/config/testdata/` 等隔离目录。内置 `frpc` 二进制由 `internal/install/assets/` 提供，更新版本时替换文件并重新编译即可。用户态安装脚本需明确权限要求，并记录在提交说明中，确保执行安全。
