package tasks

import (
	"os"
	"testing"
)

func TestNewScheduler(t *testing.T) {
	scheduler := NewScheduler()

	if scheduler == nil {
		t.Fatal("NewScheduler() 返回了 nil")
	}

	expectedPath := "/tmp/cos-photo-crontab"
	if scheduler.crontabPath != expectedPath {
		t.Errorf("期望 crontabPath 为 %s，实际为 %s", expectedPath, scheduler.crontabPath)
	}
}

func TestScheduler_ViewScheduledTasks(t *testing.T) {
	scheduler := NewScheduler()

	// 清理测试文件
	defer os.Remove(scheduler.crontabPath)

	// 创建测试文件
	testContent := "# Test cron job\n0 2 * * * /usr/bin/cos-photo backup\n"
	err := os.WriteFile(scheduler.crontabPath, []byte(testContent), 0644)
	if err != nil {
		t.Fatalf("创建测试文件失败: %v", err)
	}

	// 测试查看任务（这里我们主要测试不会panic）
	// 实际的输出验证需要更复杂的测试设置
	scheduler.ViewScheduledTasks()
}

func TestScheduler_BackupData(t *testing.T) {
	scheduler := NewScheduler()

	// 确保data目录存在
	err := os.MkdirAll("data", 0755)
	if err != nil {
		t.Fatalf("创建data目录失败: %v", err)
	}

	// 创建测试用的list.json文件
	testContent := `{"test": "data"}`
	err = os.WriteFile("data/list.json", []byte(testContent), 0644)
	if err != nil {
		t.Fatalf("创建测试数据文件失败: %v", err)
	}

	// 清理测试文件
	defer func() {
		os.Remove("data/list.json")
		os.RemoveAll("data/backup")
	}()

	// 测试备份功能
	err = scheduler.BackupData()
	if err != nil {
		t.Errorf("BackupData() 返回错误: %v", err)
	}

	// 验证备份文件是否存在
	backupFiles, err := os.ReadDir("data/backup")
	if err != nil {
		t.Fatalf("读取备份目录失败: %v", err)
	}

	if len(backupFiles) == 0 {
		t.Error("期望找到备份文件，但目录为空")
	}
}