package webserver

import (
	"context"
	"fmt"
	"time"

	"index-go/config"
	"index-go/core"
	"index-go/utils"
)

// Run 启动内置 Web 服务并阻塞运行
func Run(cfg *config.Config) error {
	if err := utils.InitDefaultLogger(); err != nil {
		fmt.Printf("❌ 日志初始化失败: %v\n", err)
	}

	engine, err := core.NewIndexEngine(cfg)
	if err != nil {
		return fmt.Errorf("创建索引引擎失败: %w", err)
	}

	ctx, cancel := context.WithTimeout(context.Background(), 2*time.Minute)
	defer cancel()
	if err := engine.Refresh(ctx); err != nil {
		fmt.Printf("⚠️ 首次刷新索引失败: %v\n", err)
	}

	server := New(engine, cfg)
	fmt.Printf("🌐 Web 索引服务已准备就绪: %s\n", server.DisplayURL())
	fmt.Println("按 Ctrl+C 退出服务。")
	return server.Start()
}
