package core

// COS API 相关常量
const (
	MaxKeysPerRequest = 1000 // 每次请求最多获取的文件数量
)

// FileInfo 从 COS 获取的原始文件信息。
type FileInfo struct {
	Key          string `json:"Key"`
	Size         int64  `json:"Size"`
	LastModified string `json:"LastModified"`
}

// FileDetails 用于索引中的文件信息。
type FileDetails struct {
	Key          string `json:"key"`
	Size         int64  `json:"size"`
	LastModified string `json:"lastModified"`
}

// IndexNode 索引树的节点，可以是目录(map)或文件(*FileDetails)。
type IndexNode map[string]interface{}
