package core

import (
	"strings"

	"index-go/utils"
)

// BuildTree 根据文件列表构建内存中的索引树。
func BuildTree(files []FileInfo, prefixToRemove string) IndexNode {
	root := make(IndexNode)
	for _, item := range files {
		// 计算相对于前缀的路径
		relativeKey := strings.TrimPrefix(strings.TrimPrefix(item.Key, prefixToRemove), "/")
		parts := utils.FilterEmptyStrings(strings.Split(relativeKey, "/"))
		if len(parts) == 0 {
			continue
		}

		currentNode := root
		for i, part := range parts {
			if i == len(parts)-1 { // 最后一个部分是文件
				currentNode[part] = &FileDetails{
					Key:          item.Key,
					Size:         item.Size,
					LastModified: item.LastModified,
				}
			} else { // 中间部分是目录
				if _, exists := currentNode[part]; !exists {
					currentNode[part] = make(IndexNode)
				}
				// 类型断言并向下钻取
				if nextNode, ok := currentNode[part].(IndexNode); ok {
					currentNode = nextNode
				} else {
					utils.IndexLog("警告: 路径 '%s' 与文件 '%s' 冲突，跳过。", part, item.Key)
					break
				}
			}
		}
	}
	return root
}
