package config

import (
	"fmt"
	"time"
)

// ParseDuration 解析时间间隔字符串（如 "1h30m", "8h", "30s"）
func ParseDuration(durationStr string) (time.Duration, error) {
	if durationStr == "" {
		return 0, fmt.Errorf("时间间隔字符串不能为空")
	}

	duration, err := time.ParseDuration(durationStr)
	if err != nil {
		return 0, fmt.Errorf("无效的时间间隔格式: %s", durationStr)
	}

	return duration, nil
}

// ParseDurationOrDefault 解析时间间隔字符串，如果失败则返回默认值
func ParseDurationOrDefault(durationStr string, defaultDuration time.Duration) time.Duration {
	duration, err := ParseDuration(durationStr)
	if err != nil {
		return defaultDuration
	}
	return duration
}
