package config

const (
	// 配置相关常量
	ConfigDirName     = "app_config"
	ConfigFileName    = "config.toml"
	DefaultWebAddress = "127.0.0.1:8888"
)

// Config 存储程序运行所需的所有配置。
type Config struct {
	// 腾讯云访问凭证
	SecretId  string `toml:"SecretId"`  // 腾讯云 Secret ID
	SecretKey string `toml:"SecretKey"` // 腾讯云 Secret Key

	// COS 存储桶配置
	Bucket string `toml:"Bucket"` // COS 存储桶名称
	Region string `toml:"Region"` // COS 区域，如 ap-beijing

	// 文件过滤配置
	Prefix string `toml:"Prefix"` // 文件路径前缀，用于过滤特定目录下的文件

	// 自定义域名配置
	CustomDomain string `toml:"CustomDomain"` // 自定义域名，用于生成文件访问链接（可选）

	// Web 服务配置
	WebServer WebServerConfig `toml:"webserver"`
}

// WebServerConfig 控制内置 Web 服务
type WebServerConfig struct {
	Address string `toml:"address"`
}

// defaultConfig 提供默认配置，需要用户修改。
var defaultConfig = Config{
	SecretId: "", SecretKey: "",
	Bucket: "", Region: "",
	Prefix: "", CustomDomain: "",
	WebServer: WebServerConfig{
		Address: DefaultWebAddress,
	},
}
