# CLAUDE.md

This file provides guidance to Claude Code (claude.ai/code) when working with code in this repository.

## 项目概述

这是一个用 Go 语言编写的腾讯云对象存储（COS）索引浏览工具。它能够扫描 COS 存储桶中的文件，并将目录结构缓存在内存中，通过内置 Web 服务（默认 http://127.0.0.1:8888）实时展示，无需再上传静态 HTML。

## 核心功能

1. **配置管理**：TOML 配置文件，包含 COS 访问凭证、扫描前缀与 Web 服务监听地址
2. **文件扫描**：从 COS 存储桶列出所有匹配前缀的文件
3. **索引构建**：构建内存中的树形结构并缓存
4. **Web 展示**：通过内置 HTTP 服务输出交互式目录索引页面

## 常用命令

### 启动 Web 服务
```bash
go run main.go --run
```
默认会监听 `config.toml` 中的 `webserver.address`（缺省 `127.0.0.1:8888`），浏览器访问即可查看索引。

### 打开管理面板
```bash
go run main.go --manage
```
用于刷新索引、修改配置和管理系统服务。

## 代码架构

### 核心数据结构

- `Config`：存储程序运行配置（SecretId、SecretKey、Bucket、Region 等）
- `FileInfo`：从 COS 获取的原始文件信息
- `FileDetails`：用于索引显示的文件信息
- `IndexNode`：索引树节点，可以是目录（map）或文件（*FileDetails）

### 主要函数流程

1. `main()` - 解析参数并启动管理面板或 Web 服务
2. `loadConfig()` - 加载或创建配置文件
3. `newCosClient()` - 创建 COS 客户端
4. `listAllFiles()` - 从 COS 列出所有文件
5. `buildTree()` - 构建内存索引树
6. `IndexEngine.Refresh()` - 刷新内存缓存
7. `webserver.Server` - 提供本地目录索引用于浏览

### 配置文件位置

- 配置目录：`app_config/`
- 配置文件：`app_config/config.toml` (TOML格式)

## 依赖项

主要依赖：
- `github.com/tencentyun/cos-go-sdk-v5` - 腾讯云 COS Go SDK
- `github.com/BurntSushi/toml` - TOML 配置文件解析库

## 注意事项

- 程序使用临时目录处理生成的 HTML 文件，运行结束后会自动清理
- 支持自定义域名配置，用于生成文件访问链接
- HTML 模板内置在代码中，使用简单的表格样式显示目录结构
- 文件按名称排序，目录优先显示
