"      }(backup.go-False 0f8fc1ecb0f9cf1901f9e85557b8c890](}(namecalculateDirSizedetailfunc(dir string) (int64, error)kindKrange}(start}(lineK	characterK uend}(hK%hKuuselectionRange}(h}(hKhKuh}(hKhKuulocation}(uri-file:///Users/jik/Desktop/backup-go/backup.gorangehabsolutePath&/Users/jik/Desktop/backup-go/backup.gorelativePath	backup.gouchildren]parentNu}(haddTarEntryh<func(tw *tar.Writer, root, path string, d fs.DirEntry) errorh	Kh
}(h}(hK(hK uh}(hKhKuuh}(h}(hK(hKuh}(hK(hKuuh}(h-file:///Users/jik/Desktop/backup-go/backup.gohh%h&/Users/jik/Desktop/backup-go/backup.gohhuh]h!Nu}(hcompressDatah2func(srcDir, dstFile string) (int64, int64, error)h	Kh
}(h}(hKhK uh}(hKhKuuh}(h}(hKhKuh}(hKhKuuh}(h-file:///Users/jik/Desktop/backup-go/backup.gohh2h&/Users/jik/Desktop/backup-go/backup.gohhuh]h!Nu}(hgenerateArchivePathh
func() stringh	Kh
}(h}(hKhK uh}(hKhKuuh}(h}(hKhKuh}(hKhKuuh}(h-file:///Users/jik/Desktop/backup-go/backup.gohh?h&/Users/jik/Desktop/backup-go/backup.gohhuh]h!Nu}(h
performBackuphBfunc(cfg *Config, cosClient *cos.Client, archivePath string) errorh	Kh
}(h}(hKhK uh}(hKhKuuh}(h}(hKhKuh}(hKhKuuh}(h-file:///Users/jik/Desktop/backup-go/backup.gohhLh&/Users/jik/Desktop/backup-go/backup.gohhuh]h!Nu}(hmainhfunc()h	Kh
}(h}(hKhK uh}(hMThKuuh}(h}(hKhKuh}(hKhK	uuh}(h-file:///Users/jik/Desktop/backup-go/backup.gohhYh&/Users/jik/Desktop/backup-go/backup.gohhuh]h!Nu}(hperformOneTimeBackuph(func(cfg *Config, cosClient *cos.Client)h	Kh
}(h}(hMWhK uh}(hMghKuuh}(h}(hMWhKuh}(hMWhKuuh}(h-file:///Users/jik/Desktop/backup-go/backup.gohhfh&/Users/jik/Desktop/backup-go/backup.gohhuh]h!Nu}(hrunScheduledBackuph.func(cfg *Config, cosClient *cos.Client) errorh	Kh
}(h}(hMjhK uh}(hM~hKuuh}(h}(hMjhKuh}(hMjhKuuh}(h-file:///Users/jik/Desktop/backup-go/backup.gohhsh&/Users/jik/Desktop/backup-go/backup.gohhuh]h!Nu}(hstartDaemonModeh(func(cfg *Config, cosClient *cos.Client)h	Kh
}(h}(hMhK uh}(hMhKuuh}(h}(hMhKuh}(hMhKuuh}(h-file:///Users/jik/Desktop/backup-go/backup.gohhh&/Users/jik/Desktop/backup-go/backup.gohhuh]h!Nue](hh"h/h<hIhVhchph}econfig.go-False 045d3027b1d5e8dcf9138163097c2926](}(name	ConfigDirkindKrange}(start}(lineK	characterKuend}(hKhKuuselectionRange}(h}(hKhKuh}(hKhK
uuh}(h-file:///Users/jik/Desktop/backup-go/config.gohhh&/Users/jik/Desktop/backup-go/config.goh	config.gouh]h!Nu}(h
ConfigFilehKh}(h}(hKhKuh}(hKhKuuh}(h}(hKhKuh}(hKhKuuh}(h-file:///Users/jik/Desktop/backup-go/config.gohhh&/Users/jik/Desktop/backup-go/config.gohhuh]h!Nu}(hDefaultKeepDayshKh}(h}(hK
hKuh}(hK
hKuuh}(h}(hK
hKuh}(hK
hKuuh}(h-file:///Users/jik/Desktop/backup-go/config.gohhh&/Users/jik/Desktop/backup-go/config.gohhuh]h!Nu}(hTempDirhKh}(h}(hKhKuh}(hKhKuuh}(h}(hKhKuh}(hKhKuuh}(h-file:///Users/jik/Desktop/backup-go/config.gohhh&/Users/jik/Desktop/backup-go/config.gohhuh]h!Nu}(hLogDirhKh}(h}(hKhKuh}(hKhKuuh}(h}(hKhKuh}(hKhKuuh}(h-file:///Users/jik/Desktop/backup-go/config.gohhh&/Users/jik/Desktop/backup-go/config.gohhuh]h!Nu}(hConfigdetailstruct{...}hKh}(h}(hKhKuh}(hKhKuuh}(h}(hKhKuh}(hKhKuuchildren](}(hCosh׌	CosConfighKh}(h}(hKhKuh}(hKhKuuh}(h}(hKhKuh}(hKhKuuh!hh}(h-file:///Users/jik/Desktop/backup-go/config.gohhh&/Users/jik/Desktop/backup-go/config.gohhuh]u}(hBackuph׌BackupConfighKh}(h}(hKhKuh}(hKhK$uuh}(h}(hKhKuh}(hKhKuuh!hh}(h-file:///Users/jik/Desktop/backup-go/config.gohhh&/Users/jik/Desktop/backup-go/config.gohhuh]ueh}(h-file:///Users/jik/Desktop/backup-go/config.gohhh&/Users/jik/Desktop/backup-go/config.gohhuh!Nuhh}(h	CosConfigh׌struct{...}hKh}(h}(hKhKuh}(hKhKuuh}(h}(hKhKuh}(hKhKuuh](}(hSecretIDh׌stringhKh}(h}(hKhKuh}(hKhK$uuh}(h}(hKhKuh}(hKhK	uuh!hh}(h-file:///Users/jik/Desktop/backup-go/config.gohj  h&/Users/jik/Desktop/backup-go/config.gohhuh]u}(h	SecretKeyh׌stringhKh}(h}(hKhKuh}(hKhK%uuh}(h}(hKhKuh}(hKhK
uuh!hh}(h-file:///Users/jik/Desktop/backup-go/config.gohj  h&/Users/jik/Desktop/backup-go/config.gohhuh]u}(hBucketh׌stringhKh}(h}(hKhKuh}(hKhK!uuh}(h}(hKhKuh}(hKhKuuh!hh}(h-file:///Users/jik/Desktop/backup-go/config.gohj%  h&/Users/jik/Desktop/backup-go/config.gohhuh]u}(hRegionh׌stringhKh}(h}(hKhKuh}(hKhK!uuh}(h}(hKhKuh}(hKhKuuh!hh}(h-file:///Users/jik/Desktop/backup-go/config.gohj2  h&/Users/jik/Desktop/backup-go/config.gohhuh]u}(hPrefixh׌stringhKh}(h}(hKhKuh}(hKhK!uuh}(h}(hKhKuh}(hKhKuuh!hh}(h-file:///Users/jik/Desktop/backup-go/config.gohj?  h&/Users/jik/Desktop/backup-go/config.gohhuh]u}(hKeepDaysh׌inthKh}(h}(hKhKuh}(hKhK$uuh}(h}(hKhKuh}(hKhK	uuh!hh}(h-file:///Users/jik/Desktop/backup-go/config.gohjL  h&/Users/jik/Desktop/backup-go/config.gohhuh]ueh}(h-file:///Users/jik/Desktop/backup-go/config.gohj  h&/Users/jik/Desktop/backup-go/config.gohhuh!Nuj  j  j"  j/  j<  jI  }(hBackupConfigh׌struct{...}hKh}(h}(hK hKuh}(hK#hKuuh}(h}(hK hKuh}(hK hKuuh](}(hDataDirh׌stringhKh}(h}(hK!hKuh}(hK!hK"uuh}(h}(hK!hKuh}(hK!hKuuh!jY  h}(h-file:///Users/jik/Desktop/backup-go/config.gohjf  h&/Users/jik/Desktop/backup-go/config.gohhuh]u}(hScheduleh׌ScheduleConfighKh}(h}(hK"hKuh}(hK"hK*uuh}(h}(hK"hKuh}(hK"hK	uuh!jY  h}(h-file:///Users/jik/Desktop/backup-go/config.gohjs  h&/Users/jik/Desktop/backup-go/config.gohhuh]ueh}(h-file:///Users/jik/Desktop/backup-go/config.gohj\  h&/Users/jik/Desktop/backup-go/config.gohhuh!Nujc  jp  }(hScheduleConfigh׌struct{...}hKh}(h}(hK%hKuh}(hK*hKuuh}(h}(hK%hKuh}(hK%hKuuh](}(hEnabledh׌boolhKh}(h}(hK&hKuh}(hK&hK"uuh}(h}(hK&hKuh}(hK&hKuuh!j  h}(h-file:///Users/jik/Desktop/backup-go/config.gohj  h&/Users/jik/Desktop/backup-go/config.gohhuh]u}(hHourh׌inthKh}(h}(hK'hKuh}(hK'hKuuh}(h}(hK'hKuh}(hK'hKuuh!j  h}(h-file:///Users/jik/Desktop/backup-go/config.gohj  h&/Users/jik/Desktop/backup-go/config.gohhuh]u}(hMinuteh׌inthKh}(h}(hK(hKuh}(hK(hK!uuh}(h}(hK(hKuh}(hK(hKuuh!j  h}(h-file:///Users/jik/Desktop/backup-go/config.gohj  h&/Users/jik/Desktop/backup-go/config.gohhuh]u}(hTimezoneh׌stringhKh}(h}(hK)hKuh}(hK)hK#uuh}(h}(hK)hKuh}(hK)hK	uuh!j  h}(h-file:///Users/jik/Desktop/backup-go/config.gohj  h&/Users/jik/Desktop/backup-go/config.gohhuh]ueh}(h-file:///Users/jik/Desktop/backup-go/config.gohj  h&/Users/jik/Desktop/backup-go/config.gohhuh!Nuj  j  j  j  }(hprintLogh׌func(level, message string)hKh}(h}(hK,hK uh}(hK0hKuuh}(h}(hK,hKuh}(hK,hK
uuh}(h-file:///Users/jik/Desktop/backup-go/config.gohj  h&/Users/jik/Desktop/backup-go/config.gohhuh]h!Nu}(hexitIfErrorh׌func(err error, msg string)hKh}(h}(hK2hK uh}(hK7hKuuh}(h}(hK2hKuh}(hK2hKuuh}(h-file:///Users/jik/Desktop/backup-go/config.gohj  h&/Users/jik/Desktop/backup-go/config.gohhuh]h!Nu}(h	exitIfNilh׌"func(v T, err error, msg string) ThKh}(h}(hK9hK uh}(hK?hKuuh}(h}(hK9hKuh}(hK9hKuuh}(h-file:///Users/jik/Desktop/backup-go/config.gohj  h&/Users/jik/Desktop/backup-go/config.gohhuh]h!Nu}(hnormalizePrefixh׌func(prefix string) stringhKh}(h}(hKAhK uh}(hKGhKuuh}(h}(hKAhKuh}(hKAhKuuh}(h-file:///Users/jik/Desktop/backup-go/config.gohj  h&/Users/jik/Desktop/backup-go/config.gohhuh]h!Nu}(h	ensureDirh׌func(dir string) errorhKh}(h}(hKIhK uh}(hKOhKuuh}(h}(hKIhKuh}(hKIhKuuh}(h-file:///Users/jik/Desktop/backup-go/config.gohj  h&/Users/jik/Desktop/backup-go/config.gohhuh]h!Nu}(h
saveConfigh׌'func(cfgPath string, cfg *Config) errorhKh}(h}(hKRhK uh}(hK_hKuuh}(h}(hKRhKuh}(hKRhKuuh}(h-file:///Users/jik/Desktop/backup-go/config.gohj  h&/Users/jik/Desktop/backup-go/config.gohhuh]h!Nu}(h
loadConfigh׌%func(cfgPath string) (*Config, error)hKh}(h}(hKbhK uh}(hKnhKuuh}(h}(hKbhKuh}(hKbhKuuh}(h-file:///Users/jik/Desktop/backup-go/config.gohj  h&/Users/jik/Desktop/backup-go/config.gohhuh]h!Nu}(hgenerateDefaultConfigh׌func(configPath string) errorhKh}(h}(hKphK uh}(hKhKuuh}(h}(hKphKuh}(hKphKuuh}(h-file:///Users/jik/Desktop/backup-go/config.gohj  h&/Users/jik/Desktop/backup-go/config.gohhuh]h!Nu}(h
getTempDirh׌
func() stringhKh}(h}(hKhK uh}(hKhKuuh}(h}(hKhKuh}(hKhKuuh}(h-file:///Users/jik/Desktop/backup-go/config.gohj,  h&/Users/jik/Desktop/backup-go/config.gohhuh]h!Nu}(hprepareTempDirh׌func() errorhKh}(h}(hKhK uh}(hKhKuuh}(h}(hKhKuh}(hKhKuuh}(h-file:///Users/jik/Desktop/backup-go/config.gohj9  h&/Users/jik/Desktop/backup-go/config.gohhuh]h!Nu}(hcleanupTempDirh׌func() errorhKh}(h}(hKhK uh}(hKhKuuh}(h}(hKhKuh}(hKhKuuh}(h-file:///Users/jik/Desktop/backup-go/config.gohjF  h&/Users/jik/Desktop/backup-go/config.gohhuh]h!Nu}(hsetupDirectoriesh׌func() errorhKh}(h}(hKhK uh}(hKhKuuh}(h}(hKhKuh}(hKhKuuh}(h-file:///Users/jik/Desktop/backup-go/config.gohjS  h&/Users/jik/Desktop/backup-go/config.gohhuh]h!Nue](hhhhhhhjY  j  j  j  j  j  j  j  j  j  j)  j6  jC  jP  ecosio.go-False 5773c3547756a3707133ecf5cbda6d1d](}(namecreateCOSClientdetail&func(cfg *Config) (*cos.Client, error)kindKrange}(start}(lineK	characterK uend}(jm  K-jn  KuuselectionRange}(jk  }(jm  Kjn  Kujo  }(jm  Kjn  Kuuh}(h,file:///Users/jik/Desktop/backup-go/cosio.gohjj  h%/Users/jik/Desktop/backup-go/cosio.gohcosio.gouh]h!Nu}(jd  testCOSConnectionjf  -func(client *cos.Client, bucket string) errorjh  Kji  }(jk  }(jm  K/jn  K ujo  }(jm  K7jn  Kuujq  }(jk  }(jm  K/jn  Kujo  }(jm  K/jn  Kuuh}(h,file:///Users/jik/Desktop/backup-go/cosio.gohj}  h%/Users/jik/Desktop/backup-go/cosio.gohjx  uh]h!Nu}(jd  friendlyDurationjf  func(d time.Duration) stringjh  Kji  }(jk  }(jm  K;jn  K ujo  }(jm  KQjn  Kuujq  }(jk  }(jm  K;jn  Kujo  }(jm  K;jn  Kuuh}(h,file:///Users/jik/Desktop/backup-go/cosio.gohj  h%/Users/jik/Desktop/backup-go/cosio.gohjx  uh]h!Nu}(jd  progressReaderjf  struct{...}jh  Kji  }(jk  }(jm  KSjn  Kujo  }(jm  K\jn  Kuujq  }(jk  }(jm  KSjn  Kujo  }(jm  KSjn  Kuuchildren](}(jd  rjf  	io.Readerjh  Kji  }(jk  }(jm  KTjn  Kujo  }(jm  KTjn  Kuujq  }(jk  }(jm  KTjn  Kujo  }(jm  KTjn  Kuuh!j  h}(h,file:///Users/jik/Desktop/backup-go/cosio.gohj  h%/Users/jik/Desktop/backup-go/cosio.gohjx  uh]u}(jd  totaljf  int64jh  Kji  }(jk  }(jm  KUjn  Kujo  }(jm  KUjn  Kuujq  }(jk  }(jm  KUjn  Kujo  }(jm  KUjn  Kuuh!j  h}(h,file:///Users/jik/Desktop/backup-go/cosio.gohj  h%/Users/jik/Desktop/backup-go/cosio.gohjx  uh]u}(jd  readjf  int64jh  Kji  }(jk  }(jm  KVjn  Kujo  }(jm  KVjn  Kuujq  }(jk  }(jm  KVjn  Kujo  }(jm  KVjn  Kuuh!j  h}(h,file:///Users/jik/Desktop/backup-go/cosio.gohj  h%/Users/jik/Desktop/backup-go/cosio.gohjx  uh]u}(jd  lastTimejf  	time.Timejh  Kji  }(jk  }(jm  KWjn  Kujo  }(jm  KWjn  Kuujq  }(jk  }(jm  KWjn  Kujo  }(jm  KWjn  K	uuh!j  h}(h,file:///Users/jik/Desktop/backup-go/cosio.gohj  h%/Users/jik/Desktop/backup-go/cosio.gohjx  uh]u}(jd  lastReadjf  int64jh  Kji  }(jk  }(jm  KXjn  Kujo  }(jm  KXjn  Kuujq  }(jk  }(jm  KXjn  Kujo  }(jm  KXjn  K	uuh!j  h}(h,file:///Users/jik/Desktop/backup-go/cosio.gohj  h%/Users/jik/Desktop/backup-go/cosio.gohjx  uh]u}(jd  intervaljf  
time.Durationjh  Kji  }(jk  }(jm  KYjn  Kujo  }(jm  KYjn  Kuujq  }(jk  }(jm  KYjn  Kujo  }(jm  KYjn  K	uuh!j  h}(h,file:///Users/jik/Desktop/backup-go/cosio.gohj  h%/Users/jik/Desktop/backup-go/cosio.gohjx  uh]u}(jd  onTickjf  0func(read, total, rate int64, eta time.Duration)jh  Kji  }(jk  }(jm  KZjn  Kujo  }(jm  KZjn  K:uujq  }(jk  }(jm  KZjn  Kujo  }(jm  KZjn  Kuuh!j  h}(h,file:///Users/jik/Desktop/backup-go/cosio.gohj  h%/Users/jik/Desktop/backup-go/cosio.gohjx  uh]u}(jd  finishedjf  booljh  Kji  }(jk  }(jm  K[jn  Kujo  }(jm  K[jn  Kuujq  }(jk  }(jm  K[jn  Kujo  }(jm  K[jn  K	uuh!j  h}(h,file:///Users/jik/Desktop/backup-go/cosio.gohj  h%/Users/jik/Desktop/backup-go/cosio.gohjx  uh]ueh}(h,file:///Users/jik/Desktop/backup-go/cosio.gohj  h%/Users/jik/Desktop/backup-go/cosio.gohjx  uh!Nuj  j  j  j  j  j  j  j  }(jd  newProgressReaderjf  func(r io.Reader, total int64, interval time.Duration, onTick func(read, total, rate int64, eta time.Duration)) *progressReaderjh  Kji  }(jk  }(jm  K^jn  K ujo  }(jm  Kejn  Kuujq  }(jk  }(jm  K^jn  Kujo  }(jm  K^jn  Kuuh}(h,file:///Users/jik/Desktop/backup-go/cosio.gohj
  h%/Users/jik/Desktop/backup-go/cosio.gohjx  uh]h!Nu}(jd  (*progressReader).Readjf  func(b []byte) (int, error)jh  Kji  }(jk  }(jm  Kgjn  K ujo  }(jm  Kjn  Kuujq  }(jk  }(jm  Kgjn  Kujo  }(jm  Kgjn  Kuuh}(h,file:///Users/jik/Desktop/backup-go/cosio.gohj  h%/Users/jik/Desktop/backup-go/cosio.gohjx  uh]h!Nu}(jd  uploadToCOSjf  9func(client *cos.Client, localFile, cosPath string) errorjh  Kji  }(jk  }(jm  Kjn  K ujo  }(jm  Kjn  Kuujq  }(jk  }(jm  Kjn  Kujo  }(jm  Kjn  Kuuh}(h,file:///Users/jik/Desktop/backup-go/cosio.gohj'  h%/Users/jik/Desktop/backup-go/cosio.gohjx  uh]h!Nu}(jd  isBackupObjectjf  func(key string) booljh  Kji  }(jk  }(jm  Kjn  K ujo  }(jm  Kjn  Kuujq  }(jk  }(jm  Kjn  Kujo  }(jm  Kjn  Kuuh}(h,file:///Users/jik/Desktop/backup-go/cosio.gohj4  h%/Users/jik/Desktop/backup-go/cosio.gohjx  uh]h!Nu}(jd  parseBackupTimejf  "func(key string) (time.Time, bool)jh  Kji  }(jk  }(jm  Kjn  K ujo  }(jm  Kjn  Kuujq  }(jk  }(jm  Kjn  Kujo  }(jm  Kjn  Kuuh}(h,file:///Users/jik/Desktop/backup-go/cosio.gohjA  h%/Users/jik/Desktop/backup-go/cosio.gohjx  uh]h!Nu}(jd  deleteExpiredBackupsjf  Jfunc(client *cos.Client, _ string, cosBasePath string, keepDays int) errorjh  Kji  }(jk  }(jm  Kjn  K ujo  }(jm  M6jn  Kuujq  }(jk  }(jm  Kjn  Kujo  }(jm  Kjn  Kuuh}(h,file:///Users/jik/Desktop/backup-go/cosio.gohjN  h%/Users/jik/Desktop/backup-go/cosio.gohjx  uh]h!Nue](jc  jz  j  j  j
  j  j$  j1  j>  jK  ebackup.go-True 148d5a6f9c4ab76a184c11d7a291daa5](}(namecalculateDirSizedetailfunc(dir string) (int64, error)kindKrange}(start}(lineK	characterK uend}(jh  K"ji  KuuselectionRange}(jf  }(jh  Kji  Kujj  }(jh  Kji  Kuulocation}(uri-file:///Users/jik/Desktop/backup-go/backup.gorangeje  absolutePath&/Users/jik/Desktop/backup-go/backup.gorelativePath	backup.goubodyXQ  func calculateDirSize(dir string) (int64, error) {
	var size int64
	err := filepath.WalkDir(dir, func(p string, d fs.DirEntry, err error) error {
		if err != nil {
			return err
		}
		if d.Type().IsRegular() {
			info, err := d.Info()
			if err != nil {
				return err
			}
			size += info.Size()
		}
		return nil
	})
	return size, err
}children]parentNu}(j_  addTarEntryja  <func(tw *tar.Writer, root, path string, d fs.DirEntry) errorjc  Kjd  }(jf  }(jh  K%ji  K ujj  }(jh  Kmji  Kuujl  }(jf  }(jh  K%ji  Kujj  }(jh  K%ji  Kuujp  }(jr  -file:///Users/jik/Desktop/backup-go/backup.gojt  j  ju  &/Users/jik/Desktop/backup-go/backup.gojw  jx  ujy  Xa  func addTarEntry(tw *tar.Writer, root, path string, d fs.DirEntry) error {
	rel, err := filepath.Rel(root, path)
	if err != nil {
		return fmt.Errorf("计算相对路径失败: %w", err)
	}
	// 跳过根目录自身的条目 "."
	if rel == "." {
		return nil
	}
	name := filepath.ToSlash(rel)

	info, err := d.Info()
	if err != nil {
		return fmt.Errorf("获取文件信息失败: %w", err)
	}

	// 符号链接：保留为链接条目（不解引用）
	if d.Type()&os.ModeSymlink != 0 {
		link, err := os.Readlink(path)
		if err != nil {
			return fmt.Errorf("读取符号链接失败: %w", err)
		}
		h, err := tar.FileInfoHeader(info, filepath.ToSlash(link))
		if err != nil {
			return fmt.Errorf("创建 tar header 失败: %w", err)
		}
		h.Name = name
		return tw.WriteHeader(h)
	}

	// 目录：统一以 / 结尾，兼容性更好
	if d.IsDir() {
		h, err := tar.FileInfoHeader(info, "")
		if err != nil {
			return fmt.Errorf("创建 tar header 失败: %w", err)
		}
		if !strings.HasSuffix(name, "/") {
			name += "/"
		}
		h.Name = name
		return tw.WriteHeader(h)
	}

	// 常规文件：仅保留权限位（与原逻辑一致）
	if info.Mode().IsRegular() {
		h := &tar.Header{
			Name:    name,
			Size:    info.Size(),
			Mode:    int64(info.Mode().Perm()),
			ModTime: info.ModTime(),
		}
		if err := tw.WriteHeader(h); err != nil {
			return fmt.Errorf("写入 tar header 失败: %w", err)
		}
		f, err := os.Open(path)
		if err != nil {
			return fmt.Errorf("打开文件失败: %w", err)
		}
		defer f.Close()
		if _, err := io.Copy(tw, f); err != nil {
			return fmt.Errorf("拷贝文件内容失败: %w", err)
		}
		return nil
	}

	// 其他类型：尽力写入 header（FIFO/设备等，通常很少见）
	h, err := tar.FileInfoHeader(info, "")
	if err != nil {
		return fmt.Errorf("创建 tar header 失败: %w", err)
	}
	h.Name = name
	return tw.WriteHeader(h)
}j{  ]j}  Nu}(j_  compressDataja  2func(srcDir, dstFile string) (int64, int64, error)jc  Kjd  }(jf  }(jh  Kpji  K ujj  }(jh  Kji  Kuujl  }(jf  }(jh  Kpji  Kujj  }(jh  Kpji  Kuujp  }(jr  -file:///Users/jik/Desktop/backup-go/backup.gojt  j  ju  &/Users/jik/Desktop/backup-go/backup.gojw  jx  ujy  X  func compressData(srcDir, dstFile string) (int64, int64, error) {
	printLog("backup", "开始计算源目录大小: "+srcDir)
	originalSize, err := calculateDirSize(srcDir)
	if err != nil {
		return 0, 0, fmt.Errorf("计算源目录大小失败: %w", err)
	}
	if originalSize == 0 {
		return 0, 0, fmt.Errorf("源目录 %s 为空，跳过备份", srcDir)
	}
	printLog("backup", fmt.Sprintf("源目录大小: %s (%d bytes)", humanize.Bytes(uint64(originalSize)), originalSize))

	dst, err := os.Create(dstFile)
	if err != nil {
		return 0, 0, fmt.Errorf("创建压缩目标文件失败: %w", err)
	}
	// 注意：不要提前 defer 关闭 writer，确保先 Close 再 Stat
	defer func() {
		_ = dst.Close()
		if err != nil {
			_ = os.Remove(dstFile)
		}
	}()

	zs, err := zstd.NewWriter(dst, zstd.WithEncoderLevel(zstd.SpeedBestCompression))
	if err != nil {
		return 0, 0, fmt.Errorf("创建 zstd 压缩器失败: %w", err)
	}
	tw := tar.NewWriter(zs)

	printLog("backup", fmt.Sprintf("开始压缩打包 (zstd) %s → %s", srcDir, dstFile))
	if err := filepath.WalkDir(srcDir, func(p string, d fs.DirEntry, err error) error {
		if err != nil {
			return err
		}
		return addTarEntry(tw, srcDir, p, d)
	}); err != nil {
		_ = tw.Close()
		_ = zs.Close()
		return 0, 0, fmt.Errorf("遍历并打包目录失败: %w", err)
	}

	// 先关闭 tar writer 和 zstd writer，确保数据落盘
	if err := tw.Close(); err != nil {
		_ = zs.Close()
		return 0, 0, fmt.Errorf("关闭 tar 写入器失败: %w", err)
	}
	if err := zs.Close(); err != nil {
		return 0, 0, fmt.Errorf("关闭 zstd 压缩器失败: %w", err)
	}

	// 现在再统计压缩后的大小，避免统计到未刷新的尺寸
	info, err := os.Stat(dstFile)
	if err != nil {
		return 0, 0, fmt.Errorf("获取压缩文件大小失败: %w", err)
	}
	compressedSize := info.Size()

	printLog("backup", "压缩完成")
	printLog("backup", "原始大小: "+humanize.Bytes(uint64(originalSize)))
	printLog("backup", "压缩后大小: "+humanize.Bytes(uint64(compressedSize)))
	if originalSize > 0 {
		printLog("backup", fmt.Sprintf("压缩率: %.2f%%", float64(compressedSize)/float64(originalSize)*100))
	}
	return originalSize, compressedSize, nil
}j{  ]j}  Nu}(j_  generateArchivePathja  
func() stringjc  Kjd  }(jf  }(jh  Kji  K ujj  }(jh  Kji  Kuujl  }(jf  }(jh  Kji  Kujj  }(jh  Kji  Kuujp  }(jr  -file:///Users/jik/Desktop/backup-go/backup.gojt  j  ju  &/Users/jik/Desktop/backup-go/backup.gojw  jx  ujy  func generateArchivePath() string {
	return filepath.Join(TmpDir, fmt.Sprintf("backup-%s.tar.zst", time.Now().Format("20060102-150405")))
}j{  ]j}  Nu}(j_  
performBackupja  Bfunc(cfg *Config, cosClient *cos.Client, archivePath string) errorjc  Kjd  }(jf  }(jh  Kji  K ujj  }(jh  Kji  Kuujl  }(jf  }(jh  Kji  Kujj  }(jh  Kji  Kuujp  }(jr  -file:///Users/jik/Desktop/backup-go/backup.gojt  j  ju  &/Users/jik/Desktop/backup-go/backup.gojw  jx  ujy  X  func performBackup(cfg *Config, cosClient *cos.Client, archivePath string) error {
	printLog("backup", "开始备份...")
	_, _, err := compressData(DataDir, archivePath)
	if err != nil && strings.Contains(err.Error(), "为空，跳过备份") {
		printLog("skip", err.Error())
		_ = os.RemoveAll(TmpDir)
		os.Exit(0)
	}
	if err != nil {
		return fmt.Errorf("压缩失败: %w", err)
	}
	return uploadToCOS(cosClient, archivePath, cfg.Prefix+filepath.Base(archivePath))
}j{  ]j}  Nu}(j_  mainja  func()jc  Kjd  }(jf  }(jh  Kji  K ujj  }(jh  Kji  Kuujl  }(jf  }(jh  Kji  Kujj  }(jh  Kji  K	uujp  }(jr  -file:///Users/jik/Desktop/backup-go/backup.gojt  j  ju  &/Users/jik/Desktop/backup-go/backup.gojw  jx  ujy  XM  func main() {
	exitIfError(setupDirectories(), "确保目录存在失败")

	cfgPath := filepath.Join(ConfigDir, ConfigFile)
	if _, err := os.Stat(cfgPath); os.IsNotExist(err) {
		exitIfError(generateDefaultConfig(cfgPath), "生成默认配置文件失败")
		os.Exit(0)
	}

	cfg, err := loadConfig(cfgPath)
	cfg = exitIfNil(cfg, err, "加载配置失败")

	client, err := createCOSClient(cfg)
	client = exitIfNil(client, err, "创建 COS 客户端失败")

	exitIfError(testCOSConnection(client, cfg.Bucket), "COS 连接测试失败")
	exitIfError(verifyDataDir(), "验证数据目录失败")
	exitIfError(prepareTempDir(), "准备临时目录失败")

	archivePath := generateArchivePath()
	if err := performBackup(cfg, client, archivePath); err != nil {
		printLog("error", err.Error())
		_ = os.RemoveAll(TmpDir)
		os.Exit(1)
	}

	if err := deleteExpiredBackups(client, cfg.Bucket, cfg.Prefix, cfg.KeepDays); err != nil {
		printLog("error", fmt.Sprintf("清理过期备份失败: %v", err))
	}

	exitIfError(cleanupTempDir(), "清理临时目录失败")
	printLog("done", "备份流程完成")
}j{  ]j}  Nue](j^  j~  j  j  j  j  econfig.go-True 9c5772ea1965829b499ff7a04b149749](}(nameDataDirkindKrange}(start}(lineK
	characterKuend}(j  K
j  KuuselectionRange}(j  }(j  K
j  Kuj  }(j  K
j  Kuujp  }(jr  -file:///Users/jik/Desktop/backup-go/config.gojt  j  ju  &/Users/jik/Desktop/backup-go/config.gojw  	config.goujy  DataDir    = "data"j{  ]j}  Nu}(j  	ConfigDirj  Kj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  K
uujp  }(jr  -file:///Users/jik/Desktop/backup-go/config.gojt  j  ju  &/Users/jik/Desktop/backup-go/config.gojw  j  ujy  ConfigDir  = "config"j{  ]j}  Nu}(j  TmpDirj  Kj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuujp  }(jr  -file:///Users/jik/Desktop/backup-go/config.gojt  j  ju  &/Users/jik/Desktop/backup-go/config.gojw  j  ujy  TmpDir     = "tmp"j{  ]j}  Nu}(j  
ConfigFilej  Kj  }(j  }(j  K
j  Kuj  }(j  K
j  Kuuj  }(j  }(j  K
j  Kuj  }(j  K
j  Kuujp  }(jr  -file:///Users/jik/Desktop/backup-go/config.gojt  j  ju  &/Users/jik/Desktop/backup-go/config.gojw  j  ujy  ConfigFile = "config.json"j{  ]j}  Nu}(j  DefaultCOSPathj  Kj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuujp  }(jr  -file:///Users/jik/Desktop/backup-go/config.gojt  j	  ju  &/Users/jik/Desktop/backup-go/config.gojw  j  ujy  DefaultCOSPath  = "backup"j{  ]j}  Nu}(j  DefaultKeepDaysj  Kj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuujp  }(jr  -file:///Users/jik/Desktop/backup-go/config.gojt  j  ju  &/Users/jik/Desktop/backup-go/config.gojw  j  ujy  DefaultKeepDays = 30j{  ]j}  Nu}(j  Configdetailstruct{...}j  Kj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuchildren](}(j  SecretIDj#  stringj  Kj  }(j  }(j  Kj  Kuj  }(j  Kj  K#uuj  }(j  }(j  Kj  Kuj  }(j  Kj  K	uuj}  j!  jp  }(jr  -file:///Users/jik/Desktop/backup-go/config.gojt  j0  ju  &/Users/jik/Desktop/backup-go/config.gojw  j  ujy  "SecretID  string `json:"SecretID"`j{  ]u}(j  	SecretKeyj#  stringj  Kj  }(j  }(j  Kj  Kuj  }(j  Kj  K$uuj  }(j  }(j  Kj  Kuj  }(j  Kj  K
uuj}  j!  jp  }(jr  -file:///Users/jik/Desktop/backup-go/config.gojt  j>  ju  &/Users/jik/Desktop/backup-go/config.gojw  j  ujy  #SecretKey string `json:"SecretKey"`j{  ]u}(j  Bucketj#  stringj  Kj  }(j  }(j  Kj  Kuj  }(j  Kj  K!uuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj}  j!  jp  }(jr  -file:///Users/jik/Desktop/backup-go/config.gojt  jL  ju  &/Users/jik/Desktop/backup-go/config.gojw  j  ujy   Bucket    string `json:"Bucket"`j{  ]u}(j  Regionj#  stringj  Kj  }(j  }(j  Kj  Kuj  }(j  Kj  K!uuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj}  j!  jp  }(jr  -file:///Users/jik/Desktop/backup-go/config.gojt  jZ  ju  &/Users/jik/Desktop/backup-go/config.gojw  j  ujy   Region    string `json:"Region"`j{  ]u}(j  Prefixj#  stringj  Kj  }(j  }(j  Kj  Kuj  }(j  Kj  K!uuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj}  j!  jp  }(jr  -file:///Users/jik/Desktop/backup-go/config.gojt  jh  ju  &/Users/jik/Desktop/backup-go/config.gojw  j  ujy   Prefix    string `json:"Prefix"`j{  ]u}(j  KeepDaysj#  intj  Kj  }(j  }(j  Kj  Kuj  }(j  Kj  K#uuj  }(j  }(j  Kj  Kuj  }(j  Kj  K	uuj}  j!  jp  }(jr  -file:///Users/jik/Desktop/backup-go/config.gojt  jv  ju  &/Users/jik/Desktop/backup-go/config.gojw  j  ujy  "KeepDays  int    `json:"KeepDays"`j{  ]uejp  }(jr  -file:///Users/jik/Desktop/backup-go/config.gojt  j%  ju  &/Users/jik/Desktop/backup-go/config.gojw  j  ujy  Config struct {
	SecretID  string `json:"SecretID"`
	SecretKey string `json:"SecretKey"`
	Bucket    string `json:"Bucket"`
	Region    string `json:"Region"`
	Prefix    string `json:"Prefix"`
	KeepDays  int    `json:"KeepDays"`
}j}  Nuj-  j;  jI  jW  je  js  }(j  printLogj#  func(level, message string)j  Kj  }(j  }(j  Kj  K uj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  K
uujp  }(jr  -file:///Users/jik/Desktop/backup-go/config.gojt  j  ju  &/Users/jik/Desktop/backup-go/config.gojw  j  ujy  Qfunc printLog(level, message string) {
	fmt.Printf("[%s] %s\n", level, message)
}j{  ]j}  Nu}(j  exitIfErrorj#  func(err error, msg string)j  Kj  }(j  }(j  K j  K uj  }(j  K%j  Kuuj  }(j  }(j  K j  Kuj  }(j  K j  Kuujp  }(jr  -file:///Users/jik/Desktop/backup-go/config.gojt  j  ju  &/Users/jik/Desktop/backup-go/config.gojw  j  ujy  func exitIfError(err error, msg string) {
	if err != nil {
		printLog("error", fmt.Sprintf("%s: %v", msg, err))
		os.Exit(1)
	}
}j{  ]j}  Nu}(j  	exitIfNilj#  "func(v T, err error, msg string) Tj  Kj  }(j  }(j  K'j  K uj  }(j  K-j  Kuuj  }(j  }(j  K'j  Kuj  }(j  K'j  Kuujp  }(jr  -file:///Users/jik/Desktop/backup-go/config.gojt  j  ju  &/Users/jik/Desktop/backup-go/config.gojw  j  ujy  func exitIfNil[T any](v T, err error, msg string) T {
	if err != nil {
		printLog("error", fmt.Sprintf("%s: %v", msg, err))
		os.Exit(1)
	}
	return v
}j{  ]j}  Nu}(j  normalizePrefixj#  func(prefix string) stringj  Kj  }(j  }(j  K/j  K uj  }(j  K5j  Kuuj  }(j  }(j  K/j  Kuj  }(j  K/j  Kuujp  }(jr  -file:///Users/jik/Desktop/backup-go/config.gojt  j  ju  &/Users/jik/Desktop/backup-go/config.gojw  j  ujy  zfunc normalizePrefix(prefix string) string {
	p := strings.Trim(prefix, "/")
	if p != "" {
		return p + "/"
	}
	return p
}j{  ]j}  Nu}(j  	ensureDirj#  func(dir string) errorj  Kj  }(j  }(j  K7j  K uj  }(j  K=j  Kuuj  }(j  }(j  K7j  Kuj  }(j  K7j  Kuujp  }(jr  -file:///Users/jik/Desktop/backup-go/config.gojt  j  ju  &/Users/jik/Desktop/backup-go/config.gojw  j  ujy  func ensureDir(dir string) error {
	if _, err := os.Stat(dir); os.IsNotExist(err) {
		printLog("info", "创建目录: "+dir)
		return os.MkdirAll(dir, 0755)
	}
	return nil
}j{  ]j}  Nu}(j  generateDefaultConfigj#  func(configPath string) errorj  Kj  }(j  }(j  K?j  K uj  }(j  KSj  Kuuj  }(j  }(j  K?j  Kuj  }(j  K?j  Kuujp  }(jr  -file:///Users/jik/Desktop/backup-go/config.gojt  j  ju  &/Users/jik/Desktop/backup-go/config.gojw  j  ujy  X  func generateDefaultConfig(configPath string) error {
	def := Config{
		SecretID:  "AKID_xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
		SecretKey: "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
		// 注意：Bucket 必须是 name-appid 格式
		Bucket:   "your-bucket-name-appid",
		Region:   "ap-shanghai",
		Prefix:   DefaultCOSPath,
		KeepDays: DefaultKeepDays,
	}
	b, err := json.MarshalIndent(def, "", "  ")
	if err != nil {
		return fmt.Errorf("序列化默认配置失败: %w", err)
	}
	if err := os.WriteFile(configPath, b, 0600); err != nil {
		return fmt.Errorf("写入默认配置失败: %w", err)
	}
	printLog("init", "已生成默认配置文件 "+configPath+"，请修改后重新运行。")
	printLog("init", "注意: Bucket 需为 'name-appid' 格式，Region 形如 ap-shanghai。")
	return nil
}j{  ]j}  Nu}(j  
loadConfigj#  (func(configPath string) (*Config, error)j  Kj  }(j  }(j  KUj  K uj  }(j  Kij  Kuuj  }(j  }(j  KUj  Kuj  }(j  KUj  Kuujp  }(jr  -file:///Users/jik/Desktop/backup-go/config.gojt  j  ju  &/Users/jik/Desktop/backup-go/config.gojw  j  ujy  Xj  func loadConfig(configPath string) (*Config, error) {
	b, err := os.ReadFile(configPath)
	if err != nil {
		return nil, fmt.Errorf("读取配置失败: %w", err)
	}
	var c Config
	if err := json.Unmarshal(b, &c); err != nil {
		return nil, fmt.Errorf("解析配置失败: %w", err)
	}
	if c.SecretID == "" || c.SecretKey == "" || c.Bucket == "" || c.Region == "" {
		return nil, fmt.Errorf("配置缺少必要字段: SecretID/SecretKey/Bucket/Region")
	}
	if c.Prefix == "" {
		c.Prefix = DefaultCOSPath
	}
	if c.KeepDays <= 0 {
		c.KeepDays = DefaultKeepDays
	}
	c.Prefix = normalizePrefix(c.Prefix)
	return &c, nil
}j{  ]j}  Nu}(j  setupDirectoriesj#  func() errorj  Kj  }(j  }(j  Kkj  K uj  }(j  Krj  Kuuj  }(j  }(j  Kkj  Kuj  }(j  Kkj  Kuujp  }(jr  -file:///Users/jik/Desktop/backup-go/config.gojt  j  ju  &/Users/jik/Desktop/backup-go/config.gojw  j  ujy  func setupDirectories() error {
	for _, d := range []string{ConfigDir, TmpDir} {
		if err := ensureDir(d); err != nil {
			return fmt.Errorf("确保目录 %s 存在失败: %w", d, err)
		}
	}
	return nil
}j{  ]j}  Nu}(j  
verifyDataDirj#  func() errorj  Kj  }(j  }(j  Ktj  K uj  }(j  Kj  Kuuj  }(j  }(j  Ktj  Kuj  }(j  Ktj  Kuujp  }(jr  -file:///Users/jik/Desktop/backup-go/config.gojt  j  ju  &/Users/jik/Desktop/backup-go/config.gojw  j  ujy  XH  func verifyDataDir() error {
	fi, err := os.Stat(DataDir)
	if err != nil {
		if os.IsNotExist(err) {
			return fmt.Errorf("源数据目录 %s 不存在", DataDir)
		}
		return fmt.Errorf("检查源数据目录失败: %w", err)
	}
	if !fi.IsDir() {
		return fmt.Errorf("路径 %s 存在但不是目录", DataDir)
	}
	return nil
}j{  ]j}  Nu}(j  prepareTempDirj#  func() errorj  Kj  }(j  }(j  Kj  K uj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuujp  }(jr  -file:///Users/jik/Desktop/backup-go/config.gojt  j  ju  &/Users/jik/Desktop/backup-go/config.gojw  j  ujy  [func prepareTempDir() error {
	_ = os.RemoveAll(TmpDir)
	return os.MkdirAll(TmpDir, 0755)
}j{  ]j}  Nu}(j  cleanupTempDirj#  func() errorj  Kj  }(j  }(j  Kj  K uj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuujp  }(jr  -file:///Users/jik/Desktop/backup-go/config.gojt  j  ju  &/Users/jik/Desktop/backup-go/config.gojw  j  ujy  pfunc cleanupTempDir() error {
	printLog("cleanup", "清理本地临时文件...")
	return os.RemoveAll(TmpDir)
}j{  ]j}  Nue](j  j  j  j  j  j  j!  j  j  j  j  j  j  j  j  j  j  j  eservice.go-False 992cb66aac399b5ac16644c59b716841](}(nameServiceManagerdetailinterface{...}kindKrange}(start}(lineK
	characterKuend}(j/  Kj0  KuuselectionRange}(j-  }(j/  K
j0  Kuj1  }(j/  K
j0  Kuuchildren](}(j&  Installj(  func() errorj*  Kj+  }(j-  }(j/  Kj0  Kuj1  }(j/  Kj0  Kuuj3  }(j-  }(j/  Kj0  Kuj1  }(j/  Kj0  Kuuh!j%  h}(h.file:///Users/jik/Desktop/backup-go/service.gohj<  h'/Users/jik/Desktop/backup-go/service.goh
service.gouh]u}(j&  Startj(  func() errorj*  Kj+  }(j-  }(j/  Kj0  Kuj1  }(j/  Kj0  Kuuj3  }(j-  }(j/  Kj0  Kuj1  }(j/  Kj0  Kuuh!j%  h}(h.file:///Users/jik/Desktop/backup-go/service.gohjJ  h'/Users/jik/Desktop/backup-go/service.gohjE  uh]u}(j&  Stopj(  func() errorj*  Kj+  }(j-  }(j/  Kj0  Kuj1  }(j/  Kj0  K
uuj3  }(j-  }(j/  Kj0  Kuj1  }(j/  Kj0  Kuuh!j%  h}(h.file:///Users/jik/Desktop/backup-go/service.gohjW  h'/Users/jik/Desktop/backup-go/service.gohjE  uh]u}(j&  Restartj(  func() errorj*  Kj+  }(j-  }(j/  Kj0  Kuj1  }(j/  Kj0  Kuuj3  }(j-  }(j/  Kj0  Kuj1  }(j/  Kj0  Kuuh!j%  h}(h.file:///Users/jik/Desktop/backup-go/service.gohjd  h'/Users/jik/Desktop/backup-go/service.gohjE  uh]u}(j&  Statusj(  func() ServiceStatusj*  Kj+  }(j-  }(j/  Kj0  Kuj1  }(j/  Kj0  Kuuj3  }(j-  }(j/  Kj0  Kuj1  }(j/  Kj0  Kuuh!j%  h}(h.file:///Users/jik/Desktop/backup-go/service.gohjq  h'/Users/jik/Desktop/backup-go/service.gohjE  uh]u}(j&  	Uninstallj(  func() errorj*  Kj+  }(j-  }(j/  Kj0  Kuj1  }(j/  Kj0  Kuuj3  }(j-  }(j/  Kj0  Kuj1  }(j/  Kj0  K
uuh!j%  h}(h.file:///Users/jik/Desktop/backup-go/service.gohj~  h'/Users/jik/Desktop/backup-go/service.gohjE  uh]ueh}(h.file:///Users/jik/Desktop/backup-go/service.gohj,  h'/Users/jik/Desktop/backup-go/service.gohjE  uh!Nuj9  jG  jT  ja  jn  j{  }(j&  
ServiceStatusj(  struct{...}j*  Kj+  }(j-  }(j/  Kj0  Kuj1  }(j/  Kj0  Kuuj3  }(j-  }(j/  Kj0  Kuj1  }(j/  Kj0  Kuuj7  ](}(j&  Runningj(  boolj*  Kj+  }(j-  }(j/  Kj0  Kuj1  }(j/  Kj0  Kuuj3  }(j-  }(j/  Kj0  Kuj1  }(j/  Kj0  Kuuh!j  h}(h.file:///Users/jik/Desktop/backup-go/service.gohj  h'/Users/jik/Desktop/backup-go/service.gohjE  uh]u}(j&  PIDj(  intj*  Kj+  }(j-  }(j/  Kj0  Kuj1  }(j/  Kj0  Kuuj3  }(j-  }(j/  Kj0  Kuj1  }(j/  Kj0  Kuuh!j  h}(h.file:///Users/jik/Desktop/backup-go/service.gohj  h'/Users/jik/Desktop/backup-go/service.gohjE  uh]u}(j&  	AutoStartj(  boolj*  Kj+  }(j-  }(j/  Kj0  Kuj1  }(j/  Kj0  Kuuj3  }(j-  }(j/  Kj0  Kuj1  }(j/  Kj0  K
uuh!j  h}(h.file:///Users/jik/Desktop/backup-go/service.gohj  h'/Users/jik/Desktop/backup-go/service.gohjE  uh]u}(j&  	Installedj(  boolj*  Kj+  }(j-  }(j/  Kj0  Kuj1  }(j/  Kj0  Kuuj3  }(j-  }(j/  Kj0  Kuj1  }(j/  Kj0  K
uuh!j  h}(h.file:///Users/jik/Desktop/backup-go/service.gohj  h'/Users/jik/Desktop/backup-go/service.gohjE  uh]u}(j&  	LastErrorj(  errorj*  Kj+  }(j-  }(j/  Kj0  Kuj1  }(j/  Kj0  Kuuj3  }(j-  }(j/  Kj0  Kuj1  }(j/  Kj0  K
uuh!j  h}(h.file:///Users/jik/Desktop/backup-go/service.gohj  h'/Users/jik/Desktop/backup-go/service.gohjE  uh]ueh}(h.file:///Users/jik/Desktop/backup-go/service.gohj  h'/Users/jik/Desktop/backup-go/service.gohjE  uh!Nuj  j  j  j  j  }(j&  getServiceManagerj(  func() ServiceManagerj*  Kj+  }(j-  }(j/  K j0  K uj1  }(j/  K+j0  Kuuj3  }(j-  }(j/  K j0  Kuj1  }(j/  K j0  Kuuh}(h.file:///Users/jik/Desktop/backup-go/service.gohj  h'/Users/jik/Desktop/backup-go/service.gohjE  uh]h!Nu}(j&  MacOSServiceManagerj(  struct{...}j*  Kj+  }(j-  }(j/  K.j0  Kuj1  }(j/  K2j0  Kuuj3  }(j-  }(j/  K.j0  Kuj1  }(j/  K.j0  Kuuj7  ](}(j&  serviceNamej(  stringj*  Kj+  }(j-  }(j/  K/j0  Kuj1  }(j/  K/j0  Kuuj3  }(j-  }(j/  K/j0  Kuj1  }(j/  K/j0  Kuuh!j  h}(h.file:///Users/jik/Desktop/backup-go/service.gohj  h'/Users/jik/Desktop/backup-go/service.gohjE  uh]u}(j&  	plistPathj(  stringj*  Kj+  }(j-  }(j/  K0j0  Kuj1  }(j/  K0j0  Kuuj3  }(j-  }(j/  K0j0  Kuj1  }(j/  K0j0  K
uuh!j  h}(h.file:///Users/jik/Desktop/backup-go/service.gohj   h'/Users/jik/Desktop/backup-go/service.gohjE  uh]u}(j&  programPathj(  stringj*  Kj+  }(j-  }(j/  K1j0  Kuj1  }(j/  K1j0  Kuuj3  }(j-  }(j/  K1j0  Kuj1  }(j/  K1j0  Kuuh!j  h}(h.file:///Users/jik/Desktop/backup-go/service.gohj
  h'/Users/jik/Desktop/backup-go/service.gohjE  uh]ueh}(h.file:///Users/jik/Desktop/backup-go/service.gohj  h'/Users/jik/Desktop/backup-go/service.gohjE  uh!Nuj  j  j
  }(j&  (*MacOSServiceManager).initj(  func()j*  Kj+  }(j-  }(j/  K4j0  K uj1  }(j/  K9j0  Kuuj3  }(j-  }(j/  K4j0  Kuj1  }(j/  K4j0  K"uuh}(h.file:///Users/jik/Desktop/backup-go/service.gohj  h'/Users/jik/Desktop/backup-go/service.gohjE  uh]h!Nu}(j&  (*MacOSServiceManager).Installj(  func() errorj*  Kj+  }(j-  }(j/  K;j0  K uj1  }(j/  KUj0  Kuuj3  }(j-  }(j/  K;j0  Kuj1  }(j/  K;j0  K%uuh}(h.file:///Users/jik/Desktop/backup-go/service.gohj*  h'/Users/jik/Desktop/backup-go/service.gohjE  uh]h!Nu}(j&  (*MacOSServiceManager).Startj(  func() errorj*  Kj+  }(j-  }(j/  KWj0  K uj1  }(j/  Kaj0  Kuuj3  }(j-  }(j/  KWj0  Kuj1  }(j/  KWj0  K#uuh}(h.file:///Users/jik/Desktop/backup-go/service.gohj7  h'/Users/jik/Desktop/backup-go/service.gohjE  uh]h!Nu}(j&  (*MacOSServiceManager).Stopj(  func() errorj*  Kj+  }(j-  }(j/  Kcj0  K uj1  }(j/  Kmj0  Kuuj3  }(j-  }(j/  Kcj0  Kuj1  }(j/  Kcj0  K"uuh}(h.file:///Users/jik/Desktop/backup-go/service.gohjD  h'/Users/jik/Desktop/backup-go/service.gohjE  uh]h!Nu}(j&  (*MacOSServiceManager).Restartj(  func() errorj*  Kj+  }(j-  }(j/  Koj0  K uj1  }(j/  Kvj0  Kuuj3  }(j-  }(j/  Koj0  Kuj1  }(j/  Koj0  K%uuh}(h.file:///Users/jik/Desktop/backup-go/service.gohjQ  h'/Users/jik/Desktop/backup-go/service.gohjE  uh]h!Nu}(j&  (*MacOSServiceManager).Statusj(  func() ServiceStatusj*  Kj+  }(j-  }(j/  Kxj0  K uj1  }(j/  Kj0  Kuuj3  }(j-  }(j/  Kxj0  Kuj1  }(j/  Kxj0  K$uuh}(h.file:///Users/jik/Desktop/backup-go/service.gohj^  h'/Users/jik/Desktop/backup-go/service.gohjE  uh]h!Nu}(j&   (*MacOSServiceManager).Uninstallj(  func() errorj*  Kj+  }(j-  }(j/  Kj0  K uj1  }(j/  Kj0  Kuuj3  }(j-  }(j/  Kj0  Kuj1  }(j/  Kj0  K'uuh}(h.file:///Users/jik/Desktop/backup-go/service.gohjk  h'/Users/jik/Desktop/backup-go/service.gohjE  uh]h!Nu}(j&  +(*MacOSServiceManager).generatePlistContentj(  
func() stringj*  Kj+  }(j-  }(j/  Kj0  K uj1  }(j/  Kj0  Kuuj3  }(j-  }(j/  Kj0  Kuj1  }(j/  Kj0  K2uuh}(h.file:///Users/jik/Desktop/backup-go/service.gohjx  h'/Users/jik/Desktop/backup-go/service.gohjE  uh]h!Nu}(j&  LinuxServiceManagerj(  struct{...}j*  Kj+  }(j-  }(j/  Kj0  Kuj1  }(j/  Kj0  Kuuj3  }(j-  }(j/  Kj0  Kuj1  }(j/  Kj0  Kuuj7  ](}(j&  serviceNamej(  stringj*  Kj+  }(j-  }(j/  Kj0  Kuj1  }(j/  Kj0  Kuuj3  }(j-  }(j/  Kj0  Kuj1  }(j/  Kj0  Kuuh!j  h}(h.file:///Users/jik/Desktop/backup-go/service.gohj  h'/Users/jik/Desktop/backup-go/service.gohjE  uh]u}(j&  serviceFilej(  stringj*  Kj+  }(j-  }(j/  Kj0  Kuj1  }(j/  Kj0  Kuuj3  }(j-  }(j/  Kj0  Kuj1  }(j/  Kj0  Kuuh!j  h}(h.file:///Users/jik/Desktop/backup-go/service.gohj  h'/Users/jik/Desktop/backup-go/service.gohjE  uh]u}(j&  programPathj(  stringj*  Kj+  }(j-  }(j/  Kj0  Kuj1  }(j/  Kj0  Kuuj3  }(j-  }(j/  Kj0  Kuj1  }(j/  Kj0  Kuuh!j  h}(h.file:///Users/jik/Desktop/backup-go/service.gohj  h'/Users/jik/Desktop/backup-go/service.gohjE  uh]ueh}(h.file:///Users/jik/Desktop/backup-go/service.gohj  h'/Users/jik/Desktop/backup-go/service.gohjE  uh!Nuj  j  j  }(j&  (*LinuxServiceManager).initj(  func()j*  Kj+  }(j-  }(j/  Kj0  K uj1  }(j/  Kj0  Kuuj3  }(j-  }(j/  Kj0  Kuj1  }(j/  Kj0  K"uuh}(h.file:///Users/jik/Desktop/backup-go/service.gohj  h'/Users/jik/Desktop/backup-go/service.gohjE  uh]h!Nu}(j&  (*LinuxServiceManager).Installj(  func() errorj*  Kj+  }(j-  }(j/  Kj0  K uj1  }(j/  Mj0  Kuuj3  }(j-  }(j/  Kj0  Kuj1  }(j/  Kj0  K%uuh}(h.file:///Users/jik/Desktop/backup-go/service.gohj  h'/Users/jik/Desktop/backup-go/service.gohjE  uh]h!Nu}(j&  (*LinuxServiceManager).Startj(  func() errorj*  Kj+  }(j-  }(j/  Mj0  K uj1  }(j/  Mj0  Kuuj3  }(j-  }(j/  Mj0  Kuj1  }(j/  Mj0  K#uuh}(h.file:///Users/jik/Desktop/backup-go/service.gohj  h'/Users/jik/Desktop/backup-go/service.gohjE  uh]h!Nu}(j&  (*LinuxServiceManager).Stopj(  func() errorj*  Kj+  }(j-  }(j/  Mj0  K uj1  }(j/  Mj0  Kuuj3  }(j-  }(j/  Mj0  Kuj1  }(j/  Mj0  K"uuh}(h.file:///Users/jik/Desktop/backup-go/service.gohj  h'/Users/jik/Desktop/backup-go/service.gohjE  uh]h!Nu}(j&  (*LinuxServiceManager).Restartj(  func() errorj*  Kj+  }(j-  }(j/  Mj0  K uj1  }(j/  Mj0  Kuuj3  }(j-  }(j/  Mj0  Kuj1  }(j/  Mj0  K%uuh}(h.file:///Users/jik/Desktop/backup-go/service.gohj  h'/Users/jik/Desktop/backup-go/service.gohjE  uh]h!Nu}(j&  (*LinuxServiceManager).Statusj(  func() ServiceStatusj*  Kj+  }(j-  }(j/  M!j0  K uj1  }(j/  MFj0  Kuuj3  }(j-  }(j/  M!j0  Kuj1  }(j/  M!j0  K$uuh}(h.file:///Users/jik/Desktop/backup-go/service.gohj  h'/Users/jik/Desktop/backup-go/service.gohjE  uh]h!Nu}(j&   (*LinuxServiceManager).Uninstallj(  func() errorj*  Kj+  }(j-  }(j/  MHj0  K uj1  }(j/  M[j0  Kuuj3  }(j-  }(j/  MHj0  Kuj1  }(j/  MHj0  K'uuh}(h.file:///Users/jik/Desktop/backup-go/service.gohj  h'/Users/jik/Desktop/backup-go/service.gohjE  uh]h!Nu}(j&  -(*LinuxServiceManager).generateServiceContentj(  
func() stringj*  Kj+  }(j-  }(j/  M]j0  K uj1  }(j/  Mpj0  Kuuj3  }(j-  }(j/  M]j0  Kuj1  }(j/  M]j0  K4uuh}(h.file:///Users/jik/Desktop/backup-go/service.gohj  h'/Users/jik/Desktop/backup-go/service.gohjE  uh]h!Nu}(j&  WindowsServiceManagerj(  struct{...}j*  Kj+  }(j-  }(j/  Msj0  Kuj1  }(j/  Mvj0  Kuuj3  }(j-  }(j/  Msj0  Kuj1  }(j/  Msj0  Kuuj7  ](}(j&  serviceNamej(  stringj*  Kj+  }(j-  }(j/  Mtj0  Kuj1  }(j/  Mtj0  Kuuj3  }(j-  }(j/  Mtj0  Kuj1  }(j/  Mtj0  Kuuh!j  h}(h.file:///Users/jik/Desktop/backup-go/service.gohj+  h'/Users/jik/Desktop/backup-go/service.gohjE  uh]u}(j&  programPathj(  stringj*  Kj+  }(j-  }(j/  Muj0  Kuj1  }(j/  Muj0  Kuuj3  }(j-  }(j/  Muj0  Kuj1  }(j/  Muj0  Kuuh!j  h}(h.file:///Users/jik/Desktop/backup-go/service.gohj8  h'/Users/jik/Desktop/backup-go/service.gohjE  uh]ueh}(h.file:///Users/jik/Desktop/backup-go/service.gohj!  h'/Users/jik/Desktop/backup-go/service.gohjE  uh!Nuj(  j5  }(j&  (*WindowsServiceManager).initj(  func()j*  Kj+  }(j-  }(j/  Mxj0  K uj1  }(j/  M{j0  Kuuj3  }(j-  }(j/  Mxj0  K uj1  }(j/  Mxj0  K$uuh}(h.file:///Users/jik/Desktop/backup-go/service.gohjH  h'/Users/jik/Desktop/backup-go/service.gohjE  uh]h!Nu}(j&   (*WindowsServiceManager).Installj(  func() errorj*  Kj+  }(j-  }(j/  M}j0  K uj1  }(j/  Mj0  Kuuj3  }(j-  }(j/  M}j0  K uj1  }(j/  M}j0  K'uuh}(h.file:///Users/jik/Desktop/backup-go/service.gohjU  h'/Users/jik/Desktop/backup-go/service.gohjE  uh]h!Nu}(j&  (*WindowsServiceManager).Startj(  func() errorj*  Kj+  }(j-  }(j/  Mj0  K uj1  }(j/  Mj0  Kuuj3  }(j-  }(j/  Mj0  K uj1  }(j/  Mj0  K%uuh}(h.file:///Users/jik/Desktop/backup-go/service.gohjb  h'/Users/jik/Desktop/backup-go/service.gohjE  uh]h!Nu}(j&  (*WindowsServiceManager).Stopj(  func() errorj*  Kj+  }(j-  }(j/  Mj0  K uj1  }(j/  Mj0  Kuuj3  }(j-  }(j/  Mj0  K uj1  }(j/  Mj0  K$uuh}(h.file:///Users/jik/Desktop/backup-go/service.gohjo  h'/Users/jik/Desktop/backup-go/service.gohjE  uh]h!Nu}(j&   (*WindowsServiceManager).Restartj(  func() errorj*  Kj+  }(j-  }(j/  Mj0  K uj1  }(j/  Mj0  Kuuj3  }(j-  }(j/  Mj0  K uj1  }(j/  Mj0  K'uuh}(h.file:///Users/jik/Desktop/backup-go/service.gohj|  h'/Users/jik/Desktop/backup-go/service.gohjE  uh]h!Nu}(j&  (*WindowsServiceManager).Statusj(  func() ServiceStatusj*  Kj+  }(j-  }(j/  Mj0  K uj1  }(j/  Mj0  Kuuj3  }(j-  }(j/  Mj0  K uj1  }(j/  Mj0  K&uuh}(h.file:///Users/jik/Desktop/backup-go/service.gohj  h'/Users/jik/Desktop/backup-go/service.gohjE  uh]h!Nu}(j&  "(*WindowsServiceManager).Uninstallj(  func() errorj*  Kj+  }(j-  }(j/  Mj0  K uj1  }(j/  Mj0  Kuuj3  }(j-  }(j/  Mj0  K uj1  }(j/  Mj0  K)uuh}(h.file:///Users/jik/Desktop/backup-go/service.gohj  h'/Users/jik/Desktop/backup-go/service.gohjE  uh]h!Nu}(j&  GenericServiceManagerj(  struct{}j*  Kj+  }(j-  }(j/  Mj0  Kuj1  }(j/  Mj0  K#uuj3  }(j-  }(j/  Mj0  Kuj1  }(j/  Mj0  Kuuh}(h.file:///Users/jik/Desktop/backup-go/service.gohj  h'/Users/jik/Desktop/backup-go/service.gohjE  uh]h!Nu}(j&   (*GenericServiceManager).Installj(  func() errorj*  Kj+  }(j-  }(j/  Mj0  K uj1  }(j/  Mj0  Kuuj3  }(j-  }(j/  Mj0  K uj1  }(j/  Mj0  K'uuh}(h.file:///Users/jik/Desktop/backup-go/service.gohj  h'/Users/jik/Desktop/backup-go/service.gohjE  uh]h!Nu}(j&  (*GenericServiceManager).Startj(  func() errorj*  Kj+  }(j-  }(j/  Mj0  K uj1  }(j/  Mj0  Kuuj3  }(j-  }(j/  Mj0  K uj1  }(j/  Mj0  K%uuh}(h.file:///Users/jik/Desktop/backup-go/service.gohj  h'/Users/jik/Desktop/backup-go/service.gohjE  uh]h!Nu}(j&  (*GenericServiceManager).Stopj(  func() errorj*  Kj+  }(j-  }(j/  Mj0  K uj1  }(j/  Mj0  Kuuj3  }(j-  }(j/  Mj0  K uj1  }(j/  Mj0  K$uuh}(h.file:///Users/jik/Desktop/backup-go/service.gohj  h'/Users/jik/Desktop/backup-go/service.gohjE  uh]h!Nu}(j&   (*GenericServiceManager).Restartj(  func() errorj*  Kj+  }(j-  }(j/  Mj0  K uj1  }(j/  Mj0  Kuuj3  }(j-  }(j/  Mj0  K uj1  }(j/  Mj0  K'uuh}(h.file:///Users/jik/Desktop/backup-go/service.gohj  h'/Users/jik/Desktop/backup-go/service.gohjE  uh]h!Nu}(j&  (*GenericServiceManager).Statusj(  func() ServiceStatusj*  Kj+  }(j-  }(j/  Mj0  K uj1  }(j/  Mj0  Kuuj3  }(j-  }(j/  Mj0  K uj1  }(j/  Mj0  K&uuh}(h.file:///Users/jik/Desktop/backup-go/service.gohj  h'/Users/jik/Desktop/backup-go/service.gohjE  uh]h!Nu}(j&  "(*GenericServiceManager).Uninstallj(  func() errorj*  Kj+  }(j-  }(j/  Mj0  K uj1  }(j/  Mj0  Kuuj3  }(j-  }(j/  Mj0  K uj1  }(j/  Mj0  K)uuh}(h.file:///Users/jik/Desktop/backup-go/service.gohj  h'/Users/jik/Desktop/backup-go/service.gohjE  uh]h!Nu}(j&  getServiceStatusj(  func() ServiceStatusj*  Kj+  }(j-  }(j/  Mj0  K uj1  }(j/  Mj0  Kuuj3  }(j-  }(j/  Mj0  Kuj1  }(j/  Mj0  Kuuh}(h.file:///Users/jik/Desktop/backup-go/service.gohj  h'/Users/jik/Desktop/backup-go/service.gohjE  uh]h!Nu}(j&  getAutoStartStatusTextj(  
func() stringj*  Kj+  }(j-  }(j/  Mj0  K uj1  }(j/  M
j0  Kuuj3  }(j-  }(j/  Mj0  Kuj1  }(j/  Mj0  Kuuh}(h.file:///Users/jik/Desktop/backup-go/service.gohj  h'/Users/jik/Desktop/backup-go/service.gohjE  uh]h!Nue](j%  j  j  j  j  j'  j4  jA  jN  j[  jh  ju  j  j  j  j  j  j  j  j  j  j  jE  jR  j_  jl  jy  j  j  j  j  j  j  j  j  j  j  j  e
menu.go-False e5722c5b13946bf72895c43a6b99bef9](}(nameshowInteractiveMenudetailfunc()kindKrange}(start}(lineK	characterK uend}(j%  KBj&  KuuselectionRange}(j#  }(j%  Kj&  Kuj'  }(j%  Kj&  Kuuh}(h+file:///Users/jik/Desktop/backup-go/menu.gohj"  h$/Users/jik/Desktop/backup-go/menu.gohmenu.gouh]h!Nu}(j  handleNonInteractiveModej  func()j   Kj!  }(j#  }(j%  KEj&  K uj'  }(j%  Kaj&  Kuuj)  }(j#  }(j%  KEj&  Kuj'  }(j%  KEj&  Kuuh}(h+file:///Users/jik/Desktop/backup-go/menu.gohj5  h$/Users/jik/Desktop/backup-go/menu.gohj0  uh]h!Nu}(j  showMainMenuHeaderj  func()j   Kj!  }(j#  }(j%  Kdj&  K uj'  }(j%  Kmj&  Kuuj)  }(j#  }(j%  Kdj&  Kuj'  }(j%  Kdj&  Kuuh}(h+file:///Users/jik/Desktop/backup-go/menu.gohjB  h$/Users/jik/Desktop/backup-go/menu.gohj0  uh]h!Nu}(j  showSystemStatusj  func()j   Kj!  }(j#  }(j%  Kpj&  K uj'  }(j%  Kj&  Kuuj)  }(j#  }(j%  Kpj&  Kuj'  }(j%  Kpj&  Kuuh}(h+file:///Users/jik/Desktop/backup-go/menu.gohjO  h$/Users/jik/Desktop/backup-go/menu.gohj0  uh]h!Nu}(j  
StatusInfoj  struct{...}j   Kj!  }(j#  }(j%  Kj&  Kuj'  }(j%  Kj&  Kuuj)  }(j#  }(j%  Kj&  Kuj'  }(j%  Kj&  Kuuchildren](}(j  textj  stringj   Kj!  }(j#  }(j%  Kj&  Kuj'  }(j%  Kj&  Kuuj)  }(j#  }(j%  Kj&  Kuj'  }(j%  Kj&  Kuuh!jY  h}(h+file:///Users/jik/Desktop/backup-go/menu.gohjg  h$/Users/jik/Desktop/backup-go/menu.gohj0  uh]u}(j  detailsj  stringj   Kj!  }(j#  }(j%  Kj&  Kuj'  }(j%  Kj&  Kuuj)  }(j#  }(j%  Kj&  Kuj'  }(j%  Kj&  Kuuh!jY  h}(h+file:///Users/jik/Desktop/backup-go/menu.gohjt  h$/Users/jik/Desktop/backup-go/menu.gohj0  uh]ueh}(h+file:///Users/jik/Desktop/backup-go/menu.gohj\  h$/Users/jik/Desktop/backup-go/menu.gohj0  uh!Nujd  jq  }(j  checkConfigStatusj  func() StatusInfoj   Kj!  }(j#  }(j%  Kj&  K uj'  }(j%  Kj&  Kuuj)  }(j#  }(j%  Kj&  Kuj'  }(j%  Kj&  Kuuh}(h+file:///Users/jik/Desktop/backup-go/menu.gohj  h$/Users/jik/Desktop/backup-go/menu.gohj0  uh]h!Nu}(j  checkServiceStatusj  func() StatusInfoj   Kj!  }(j#  }(j%  Kj&  K uj'  }(j%  Kj&  Kuuj)  }(j#  }(j%  Kj&  Kuj'  }(j%  Kj&  Kuuh}(h+file:///Users/jik/Desktop/backup-go/menu.gohj  h$/Users/jik/Desktop/backup-go/menu.gohj0  uh]h!Nu}(j  checkScheduleStatusj  func() StatusInfoj   Kj!  }(j#  }(j%  Kj&  K uj'  }(j%  Kj&  Kuuj)  }(j#  }(j%  Kj&  Kuj'  }(j%  Kj&  Kuuh}(h+file:///Users/jik/Desktop/backup-go/menu.gohj  h$/Users/jik/Desktop/backup-go/menu.gohj0  uh]h!Nu}(j  checkAutoStartStatusj  func() StatusInfoj   Kj!  }(j#  }(j%  Kj&  K uj'  }(j%  Mj&  Kuuj)  }(j#  }(j%  Kj&  Kuj'  }(j%  Kj&  Kuuh}(h+file:///Users/jik/Desktop/backup-go/menu.gohj  h$/Users/jik/Desktop/backup-go/menu.gohj0  uh]h!Nu}(j  checkCOSStatusj  func() StatusInfoj   Kj!  }(j#  }(j%  Mj&  K uj'  }(j%  M$j&  Kuuj)  }(j#  }(j%  Mj&  Kuj'  }(j%  Mj&  Kuuh}(h+file:///Users/jik/Desktop/backup-go/menu.gohj  h$/Users/jik/Desktop/backup-go/menu.gohj0  uh]h!Nu}(j  checkDataStatusj  func() StatusInfoj   Kj!  }(j#  }(j%  M'j&  K uj'  }(j%  MSj&  Kuuj)  }(j#  }(j%  M'j&  Kuj'  }(j%  M'j&  Kuuh}(h+file:///Users/jik/Desktop/backup-go/menu.gohj  h$/Users/jik/Desktop/backup-go/menu.gohj0  uh]h!Nu}(j  checkConfigAndCOSStatusj  func() StatusInfoj   Kj!  }(j#  }(j%  MVj&  K uj'  }(j%  Mj&  Kuuj)  }(j#  }(j%  MVj&  Kuj'  }(j%  MVj&  Kuuh}(h+file:///Users/jik/Desktop/backup-go/menu.gohj  h$/Users/jik/Desktop/backup-go/menu.gohj0  uh]h!Nu}(j  checkBackupPathStatusj  func() StatusInfoj   Kj!  }(j#  }(j%  Mj&  K uj'  }(j%  Mj&  Kuuj)  }(j#  }(j%  Mj&  Kuj'  }(j%  Mj&  Kuuh}(h+file:///Users/jik/Desktop/backup-go/menu.gohj  h$/Users/jik/Desktop/backup-go/menu.gohj0  uh]h!Nu}(j  showMainMenuOptionsj  func()j   Kj!  }(j#  }(j%  Mj&  K uj'  }(j%  Mj&  Kuuj)  }(j#  }(j%  Mj&  Kuj'  }(j%  Mj&  Kuuh}(h+file:///Users/jik/Desktop/backup-go/menu.gohj  h$/Users/jik/Desktop/backup-go/menu.gohj0  uh]h!Nu}(j  handleImmediateBackupj  func()j   Kj!  }(j#  }(j%  Mj&  K uj'  }(j%  Mj&  Kuuj)  }(j#  }(j%  Mj&  Kuj'  }(j%  Mj&  Kuuh}(h+file:///Users/jik/Desktop/backup-go/menu.gohj  h$/Users/jik/Desktop/backup-go/menu.gohj0  uh]h!Nu}(j  showBasicStatusj  func()j   Kj!  }(j#  }(j%  Mj&  K uj'  }(j%  Mj&  Kuuj)  }(j#  }(j%  Mj&  Kuj'  }(j%  Mj&  Kuuh}(h+file:///Users/jik/Desktop/backup-go/menu.gohj	  h$/Users/jik/Desktop/backup-go/menu.gohj0  uh]h!Nu}(j  clearScreenj  func()j   Kj!  }(j#  }(j%  Mj&  K uj'  }(j%  Mj&  Kuuj)  }(j#  }(j%  Mj&  Kuj'  }(j%  Mj&  Kuuh}(h+file:///Users/jik/Desktop/backup-go/menu.gohj	  h$/Users/jik/Desktop/backup-go/menu.gohj0  uh]h!Nu}(j  getUserInputj  func(prompt string) stringj   Kj!  }(j#  }(j%  Mj&  K uj'  }(j%  M.j&  Kuuj)  }(j#  }(j%  Mj&  Kuj'  }(j%  Mj&  Kuuh}(h+file:///Users/jik/Desktop/backup-go/menu.gohj 	  h$/Users/jik/Desktop/backup-go/menu.gohj0  uh]h!Nu}(j  pauseForKeyj  func()j   Kj!  }(j#  }(j%  M1j&  K uj'  }(j%  M4j&  Kuuj)  }(j#  }(j%  M1j&  Kuj'  }(j%  M1j&  Kuuh}(h+file:///Users/jik/Desktop/backup-go/menu.gohj-	  h$/Users/jik/Desktop/backup-go/menu.gohj0  uh]h!Nu}(j  handleConfigMenuj  func()j   Kj!  }(j#  }(j%  M7j&  K uj'  }(j%  M~j&  Kuuj)  }(j#  }(j%  M7j&  Kuj'  }(j%  M7j&  Kuuh}(h+file:///Users/jik/Desktop/backup-go/menu.gohj:	  h$/Users/jik/Desktop/backup-go/menu.gohj0  uh]h!Nu}(j  editConfigFilej  func()j   Kj!  }(j#  }(j%  Mj&  K uj'  }(j%  Mj&  Kuuj)  }(j#  }(j%  Mj&  Kuj'  }(j%  Mj&  Kuuh}(h+file:///Users/jik/Desktop/backup-go/menu.gohjG	  h$/Users/jik/Desktop/backup-go/menu.gohj0  uh]h!Nu}(j  validateConfigj  func()j   Kj!  }(j#  }(j%  Mj&  K uj'  }(j%  Mj&  Kuuj)  }(j#  }(j%  Mj&  Kuj'  }(j%  Mj&  Kuuh}(h+file:///Users/jik/Desktop/backup-go/menu.gohjT	  h$/Users/jik/Desktop/backup-go/menu.gohj0  uh]h!Nu}(j  resetConfigj  func()j   Kj!  }(j#  }(j%  Mj&  K uj'  }(j%  M j&  Kuuj)  }(j#  }(j%  Mj&  Kuj'  }(j%  Mj&  Kuuh}(h+file:///Users/jik/Desktop/backup-go/menu.gohja	  h$/Users/jik/Desktop/backup-go/menu.gohj0  uh]h!Nu}(j  testCOSConnectivityj  func()j   Kj!  }(j#  }(j%  Mj&  K uj'  }(j%  M/j&  Kuuj)  }(j#  }(j%  Mj&  Kuj'  }(j%  Mj&  Kuuh}(h+file:///Users/jik/Desktop/backup-go/menu.gohjn	  h$/Users/jik/Desktop/backup-go/menu.gohj0  uh]h!Nu}(j  viewConfigFilej  func()j   Kj!  }(j#  }(j%  M2j&  K uj'  }(j%  MHj&  Kuuj)  }(j#  }(j%  M2j&  Kuj'  }(j%  M2j&  Kuuh}(h+file:///Users/jik/Desktop/backup-go/menu.gohj{	  h$/Users/jik/Desktop/backup-go/menu.gohj0  uh]h!Nu}(j  handleServiceMenuj  func()j   Kj!  }(j#  }(j%  MKj&  K uj'  }(j%  Mj&  Kuuj)  }(j#  }(j%  MKj&  Kuj'  }(j%  MKj&  Kuuh}(h+file:///Users/jik/Desktop/backup-go/menu.gohj	  h$/Users/jik/Desktop/backup-go/menu.gohj0  uh]h!Nu}(j  showDetailedServiceStatusj  func()j   Kj!  }(j#  }(j%  Mj&  K uj'  }(j%  Mj&  Kuuj)  }(j#  }(j%  Mj&  Kuj'  }(j%  Mj&  Kuuh}(h+file:///Users/jik/Desktop/backup-go/menu.gohj	  h$/Users/jik/Desktop/backup-go/menu.gohj0  uh]h!Nu}(j  installAutoStartj  func()j   Kj!  }(j#  }(j%  Mj&  K uj'  }(j%  Mj&  Kuuj)  }(j#  }(j%  Mj&  Kuj'  }(j%  Mj&  Kuuh}(h+file:///Users/jik/Desktop/backup-go/menu.gohj	  h$/Users/jik/Desktop/backup-go/menu.gohj0  uh]h!Nu}(j  startServicej  func()j   Kj!  }(j#  }(j%  Mj&  K uj'  }(j%  Mj&  Kuuj)  }(j#  }(j%  Mj&  Kuj'  }(j%  Mj&  Kuuh}(h+file:///Users/jik/Desktop/backup-go/menu.gohj	  h$/Users/jik/Desktop/backup-go/menu.gohj0  uh]h!Nu}(j  stopServicej  func()j   Kj!  }(j#  }(j%  Mj&  K uj'  }(j%  M*j&  Kuuj)  }(j#  }(j%  Mj&  Kuj'  }(j%  Mj&  Kuuh}(h+file:///Users/jik/Desktop/backup-go/menu.gohj	  h$/Users/jik/Desktop/backup-go/menu.gohj0  uh]h!Nu}(j  restartServicej  func()j   Kj!  }(j#  }(j%  M-j&  K uj'  }(j%  MGj&  Kuuj)  }(j#  }(j%  M-j&  Kuj'  }(j%  M-j&  Kuuh}(h+file:///Users/jik/Desktop/backup-go/menu.gohj	  h$/Users/jik/Desktop/backup-go/menu.gohj0  uh]h!Nu}(j  uninstallServicej  func()j   Kj!  }(j#  }(j%  MJj&  K uj'  }(j%  Myj&  Kuuj)  }(j#  }(j%  MJj&  Kuj'  }(j%  MJj&  Kuuh}(h+file:///Users/jik/Desktop/backup-go/menu.gohj	  h$/Users/jik/Desktop/backup-go/menu.gohj0  uh]h!Nu}(j  
handleLogMenuj  func()j   Kj!  }(j#  }(j%  M|j&  K uj'  }(j%  Mj&  Kuuj)  }(j#  }(j%  M|j&  Kuj'  }(j%  M|j&  Kuuh}(h+file:///Users/jik/Desktop/backup-go/menu.gohj	  h$/Users/jik/Desktop/backup-go/menu.gohj0  uh]h!Nu}(j  
showLogStatusj  func()j   Kj!  }(j#  }(j%  Mj&  K uj'  }(j%  Mj&  Kuuj)  }(j#  }(j%  Mj&  Kuj'  }(j%  Mj&  Kuuh}(h+file:///Users/jik/Desktop/backup-go/menu.gohj	  h$/Users/jik/Desktop/backup-go/menu.gohj0  uh]h!Nu}(j  getLogFilesj  func() ([]LogFileInfo, error)j   Kj!  }(j#  }(j%  Mj&  K uj'  }(j%  Mj&  Kuuj)  }(j#  }(j%  Mj&  Kuj'  }(j%  Mj&  Kuuh}(h+file:///Users/jik/Desktop/backup-go/menu.gohj	  h$/Users/jik/Desktop/backup-go/menu.gohj0  uh]h!Nu}(j  LogFileInfoj  struct{...}j   Kj!  }(j#  }(j%  Mj&  Kuj'  }(j%  Mj&  Kuuj)  }(j#  }(j%  Mj&  Kuj'  }(j%  Mj&  Kuujb  ](}(j  Namej  stringj   Kj!  }(j#  }(j%  Mj&  Kuj'  }(j%  Mj&  Kuuj)  }(j#  }(j%  Mj&  Kuj'  }(j%  Mj&  Kuuh!j
  h}(h+file:///Users/jik/Desktop/backup-go/menu.gohj
  h$/Users/jik/Desktop/backup-go/menu.gohj0  uh]u}(j  Sizej  int64j   Kj!  }(j#  }(j%  Mj&  Kuj'  }(j%  Mj&  Kuuj)  }(j#  }(j%  Mj&  Kuj'  }(j%  Mj&  Kuuh!j
  h}(h+file:///Users/jik/Desktop/backup-go/menu.gohj!
  h$/Users/jik/Desktop/backup-go/menu.gohj0  uh]u}(j  ModTimej  	time.Timej   Kj!  }(j#  }(j%  Mj&  Kuj'  }(j%  Mj&  Kuuj)  }(j#  }(j%  Mj&  Kuj'  }(j%  Mj&  Kuuh!j
  h}(h+file:///Users/jik/Desktop/backup-go/menu.gohj.
  h$/Users/jik/Desktop/backup-go/menu.gohj0  uh]ueh}(h+file:///Users/jik/Desktop/backup-go/menu.gohj

  h$/Users/jik/Desktop/backup-go/menu.gohj0  uh!Nuj
  j
  j+
  }(j  viewLatestLogsj  func()j   Kj!  }(j#  }(j%  Mj&  K uj'  }(j%  Mj&  Kuuj)  }(j#  }(j%  Mj&  Kuj'  }(j%  Mj&  Kuuh}(h+file:///Users/jik/Desktop/backup-go/menu.gohj>
  h$/Users/jik/Desktop/backup-go/menu.gohj0  uh]h!Nu}(j  displayTailLogj  &func(filename string, lines int) errorj   Kj!  }(j#  }(j%  Mj&  K uj'  }(j%  M'j&  Kuuj)  }(j#  }(j%  Mj&  Kuj'  }(j%  Mj&  Kuuh}(h+file:///Users/jik/Desktop/backup-go/menu.gohjK
  h$/Users/jik/Desktop/backup-go/menu.gohj0  uh]h!Nu}(j  viewLogFilesj  func()j   Kj!  }(j#  }(j%  M*j&  K uj'  }(j%  Mbj&  Kuuj)  }(j#  }(j%  M*j&  Kuj'  }(j%  M*j&  Kuuh}(h+file:///Users/jik/Desktop/backup-go/menu.gohjX
  h$/Users/jik/Desktop/backup-go/menu.gohj0  uh]h!Nu}(j  
searchLogsj  func()j   Kj!  }(j#  }(j%  Mej&  K uj'  }(j%  Mj&  Kuuj)  }(j#  }(j%  Mej&  Kuj'  }(j%  Mej&  Kuuh}(h+file:///Users/jik/Desktop/backup-go/menu.gohje
  h$/Users/jik/Desktop/backup-go/menu.go9      hj0  uh]h!Nu}(j  LogMatchj  struct{...}j   Kj!  }(j#  }(j%  Mj&  Kuj'  }(j%  Mj&  Kuuj)  }(j#  }(j%  Mj&  Kuj'  }(j%  Mj&  K
uujb  ](}(j  Timej  stringj   Kj!  }(j#  }(j%  Mj&  Kuj'  }(j%  Mj&  Kuuj)  }(j#  }(j%  Mj&  Kuj'  }(j%  Mj&  Kuuh!jo
  h}(h+file:///Users/jik/Desktop/backup-go/menu.gohj|
  h$/Users/jik/Desktop/backup-go/menu.gohj0  uh]u}(j  Contentj  stringj   Kj!  }(j#  }(j%  Mj&  Kuj'  }(j%  Mj&  Kuuj)  }(j#  }(j%  Mj&  Kuj'  }(j%  Mj&  Kuuh!jo
  h}(h+file:///Users/jik/Desktop/backup-go/menu.gohj
  h$/Users/jik/Desktop/backup-go/menu.gohj0  uh]ueh}(h+file:///Users/jik/Desktop/backup-go/menu.gohjr
  h$/Users/jik/Desktop/backup-go/menu.gohj0  uh!Nujy
  j
  }(j  searchInLogFilej  2func(filename, keyword string) ([]LogMatch, error)j   Kj!  }(j#  }(j%  Mj&  K uj'  }(j%  Mj&  Kuuj)  }(j#  }(j%  Mj&  Kuj'  }(j%  Mj&  Kuuh}(h+file:///Users/jik/Desktop/backup-go/menu.gohj
  h$/Users/jik/Desktop/backup-go/menu.gohj0  uh]h!Nu}(j  extractTimestampj  func(line string) stringj   Kj!  }(j#  }(j%  Mj&  K uj'  }(j%  Mj&  Kuuj)  }(j#  }(j%  Mj&  Kuj'  }(j%  Mj&  Kuuh}(h+file:///Users/jik/Desktop/backup-go/menu.gohj
  h$/Users/jik/Desktop/backup-go/menu.gohj0  uh]h!Nu}(j  cleanupLogsj  func()j   Kj!  }(j#  }(j%  Mj&  K uj'  }(j%  MDj&  Kuuj)  }(j#  }(j%  Mj&  Kuj'  }(j%  Mj&  Kuuh}(h+file:///Users/jik/Desktop/backup-go/menu.gohj
  h$/Users/jik/Desktop/backup-go/menu.gohj0  uh]h!Nu}(j  
exportLogsj  func()j   Kj!  }(j#  }(j%  MGj&  K uj'  }(j%  Mj&  Kuuj)  }(j#  }(j%  MGj&  Kuj'  }(j%  MGj&  Kuuh}(h+file:///Users/jik/Desktop/backup-go/menu.gohj
  h$/Users/jik/Desktop/backup-go/menu.gohj0  uh]h!Nu}(j  createTarGzExportj  -func(exportFile string, files []string) errorj   Kj!  }(j#  }(j%  Mj&  K uj'  }(j%  Mj&  Kuuj)  }(j#  }(j%  Mj&  Kuj'  }(j%  Mj&  Kuuh}(h+file:///Users/jik/Desktop/backup-go/menu.gohj
  h$/Users/jik/Desktop/backup-go/menu.gohj0  uh]h!Nu}(j  logSettingsj  func()j   Kj!  }(j#  }(j%  Mj&  K uj'  }(j%  Mj&  Kuuj)  }(j#  }(j%  Mj&  Kuj'  }(j%  Mj&  Kuuh}(h+file:///Users/jik/Desktop/backup-go/menu.gohj
  h$/Users/jik/Desktop/backup-go/menu.gohj0  uh]h!Nu}(j  handleScheduleMenuj  func()j   Kj!  }(j#  }(j%  Mj&  K uj'  }(j%  Mj&  Kuuj)  }(j#  }(j%  Mj&  Kuj'  }(j%  Mj&  Kuuh}(h+file:///Users/jik/Desktop/backup-go/menu.gohj
  h$/Users/jik/Desktop/backup-go/menu.gohj0  uh]h!Nu}(j  showScheduleStatusj  func()j   Kj!  }(j#  }(j%  Mj&  K uj'  }(j%  M	j&  Kuuj)  }(j#  }(j%  Mj&  Kuj'  }(j%  Mj&  Kuuh}(h+file:///Users/jik/Desktop/backup-go/menu.gohj
  h$/Users/jik/Desktop/backup-go/menu.gohj0  uh]h!Nu}(j  enableSchedulej  func()j   Kj!  }(j#  }(j%  Mj&  K uj'  }(j%  M@j&  Kuuj)  }(j#  }(j%  Mj&  Kuj'  }(j%  Mj&  Kuuh}(h+file:///Users/jik/Desktop/backup-go/menu.gohj  h$/Users/jik/Desktop/backup-go/menu.gohj0  uh]h!Nu}(j  disableSchedulej  func()j   Kj!  }(j#  }(j%  MCj&  K uj'  }(j%  Mkj&  Kuuj)  }(j#  }(j%  MCj&  Kuj'  }(j%  MCj&  Kuuh}(h+file:///Users/jik/Desktop/backup-go/menu.gohj  h$/Users/jik/Desktop/backup-go/menu.gohj0  uh]h!Nu}(j  modifyScheduleTimej  func()j   Kj!  }(j#  }(j%  Mnj&  K uj'  }(j%  Mj&  Kuuj)  }(j#  }(j%  Mnj&  Kuj'  }(j%  Mnj&  Kuuh}(h+file:///Users/jik/Desktop/backup-go/menu.gohj  h$/Users/jik/Desktop/backup-go/menu.gohj0  uh]h!Nu}(j  showNextRunTimej  func()j   Kj!  }(j#  }(j%  Mj&  K uj'  }(j%  Mj&  Kuuj)  }(j#  }(j%  Mj&  Kuj'  }(j%  Mj&  Kuuh}(h+file:///Users/jik/Desktop/backup-go/menu.gohj(  h$/Users/jik/Desktop/backup-go/menu.gohj0  uh]h!Nu}(j  runScheduledBackupNowj  func()j   Kj!  }(j#  }(j%  Mj&  K uj'  }(j%  MFj&  Kuuj)  }(j#  }(j%  Mj&  Kuj'  }(j%  Mj&  Kuuh}(h+file:///Users/jik/Desktop/backup-go/menu.gohj5  h$/Users/jik/Desktop/backup-go/menu.gohj0  uh]h!Nu}(j  viewScheduleHistoryj  func()j   Kj!  }(j#  }(j%  MIj&  K uj'  }(j%  Maj&  Kuuj)  }(j#  }(j%  MIj&  Kuj'  }(j%  MIj&  Kuuh}(h+file:///Users/jik/Desktop/backup-go/menu.gohjB  h$/Users/jik/Desktop/backup-go/menu.gohj0  uh]h!Nu}(j  displayScheduleHistoryj  func(historyFile string) errorj   Kj!  }(j#  }(j%  Mdj&  K uj'  }(j%  Mj&  Kuuj)  }(j#  }(j%  Mdj&  Kuj'  }(j%  Mdj&  Kuuh}(h+file:///Users/jik/Desktop/backup-go/menu.gohjO  h$/Users/jik/Desktop/backup-go/menu.gohj0  uh]h!Nu}(j  scheduleSettingsj  func()j   Kj!  }(j#  }(j%  Mj&  K uj'  }(j%  Mj&  Kuuj)  }(j#  }(j%  Mj&  Kuj'  }(j%  Mj&  Kuuh}(h+file:///Users/jik/Desktop/backup-go/menu.gohj\  h$/Users/jik/Desktop/backup-go/menu.gohj0  uh]h!Nu}(j  calculateNextRunTimej  'func(schedule ScheduleConfig) time.Timej   Kj!  }(j#  }(j%  Mj&  K uj'  }(j%  Mj&  Kuuj)  }(j#  }(j%  Mj&  Kuj'  }(j%  Mj&  Kuuh}(h+file:///Users/jik/Desktop/backup-go/menu.gohji  h$/Users/jik/Desktop/backup-go/menu.gohj0  uh]h!Nu}(j  formatDurationj  func(d time.Duration) stringj   Kj!  }(j#  }(j%  Mj&  K uj'  }(j%  Mj&  Kuuj)  }(j#  }(j%  Mj&  Kuj'  }(j%  Mj&  Kuuh}(h+file:///Users/jik/Desktop/backup-go/menu.gohjv  h$/Users/jik/Desktop/backup-go/menu.gohj0  uh]h!Nu}(j  recordScheduleExecutionj  #func(success bool, errorMsg string)j   Kj!  }(j#  }(j%  Mj&  K uj'  }(j%  Mj&  Kuuj)  }(j#  }(j%  Mj&  Kuj'  }(j%  Mj&  Kuuh}(h+file:///Users/jik/Desktop/backup-go/menu.gohj  h$/Users/jik/Desktop/backup-go/menu.gohj0  uh]h!Nu}(j  
fileExistsj  func(filename string) boolj   Kj!  }(j#  }(j%  Mj&  K uj'  }(j%  Mj&  Kuuj)  }(j#  }(j%  Mj&  Kuj'  }(j%  Mj&  Kuuh}(h+file:///Users/jik/Desktop/backup-go/menu.gohj  h$/Users/jik/Desktop/backup-go/menu.gohj0  uh]h!Nue](j  j2  j?  jL  jY  j  j  j  j  j  j  j  j  j  j  j	  j	  j	  j*	  j7	  jD	  jQ	  j^	  jk	  jx	  j	  j	  j	  j	  j	  j	  j	  j	  j	  j	  j
  j;
  jH
  jU
  jb
  jo
  j
  j
  j
  j
  j
  j
  j
  j
  j
  j  j  j%  j2  j?  jL  jY  jf  js  j  j  estatus.go-False cfebd86ca722481a8a4a9f8c736a1a6c](}(nameSystemStatusdetailstruct{...}kindKrange}(start}(lineK	characterKuend}(j  Kj  KuuselectionRange}(j  }(j  Kj  Kuj  }(j  Kj  Kuuchildren](}(j  ServiceRunningj  boolj  Kj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuh!j  h}(h-file:///Users/jik/Desktop/backup-go/status.gohj  h&/Users/jik/Desktop/backup-go/status.goh	status.gouh]u}(j  
ServicePIDj  intj  Kj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuh!j  h}(h-file:///Users/jik/Desktop/backup-go/status.gohj  h&/Users/jik/Desktop/backup-go/status.gohj  uh]u}(j  ConfigLoadedj  boolj  Kj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  K
uuh!j  h}(h-file:///Users/jik/Desktop/backup-go/status.gohj  h&/Users/jik/Desktop/backup-go/status.gohj  uh]u}(j  DataDirj  stringj  Kj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuh!j  h}(h-file:///Users/jik/Desktop/backup-go/status.gohj  h&/Users/jik/Desktop/backup-go/status.gohj  uh]u}(j  Bucketj  stringj  Kj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuh!j  h}(h-file:///Users/jik/Desktop/backup-go/status.gohj  h&/Users/jik/Desktop/backup-go/status.gohj  uh]u}(j  Prefixj  stringj  Kj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuh!j  h}(h-file:///Users/jik/Desktop/backup-go/status.gohj  h&/Users/jik/Desktop/backup-go/status.gohj  uh]u}(j  
LastBackupj  	time.Timej  Kj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuh!j  h}(h-file:///Users/jik/Desktop/backup-go/status.gohj  h&/Users/jik/Desktop/backup-go/status.gohj  uh]u}(j  LastBackupSuccessj  boolj  Kj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuh!j  h}(h-file:///Users/jik/Desktop/backup-go/status.gohj  h&/Users/jik/Desktop/backup-go/status.gohj  uh]u}(j  
NextBackupj  	time.Timej  Kj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuh!j  h}(h-file:///Users/jik/Desktop/backup-go/status.gohj   h&/Users/jik/Desktop/backup-go/status.gohj  uh]u}(j  ScheduleEnabledj  boolj  Kj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuh!j  h}(h-file:///Users/jik/Desktop/backup-go/status.gohj-  h&/Users/jik/Desktop/backup-go/status.gohj  uh]ueh}(h-file:///Users/jik/Desktop/backup-go/status.gohj  h&/Users/jik/Desktop/backup-go/status.gohj  uh!Nuj  j  j  j  j  j  j  j  j  j*  }(j  getCurrentSystemStatusj  func() SystemStatusj  Kj  }(j  }(j  Kj  K uj  }(j  K=j  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuh}(h-file:///Users/jik/Desktop/backup-go/status.gohj=  h&/Users/jik/Desktop/backup-go/status.gohj  uh]h!Nu}(j  getServiceRunningStatusj  func() (bool, int)j  Kj  }(j  }(j  K@j  K uj  }(j  KMj  Kuuj  }(j  }(j  K@j  Kuj  }(j  K@j  Kuuh}(h-file:///Users/jik/Desktop/backup-go/status.gohjJ  h&/Users/jik/Desktop/backup-go/status.gohj  uh]h!Nu}(j  getMacOSServiceStatusj  func() (bool, int)j  Kj  }(j  }(j  KPj  K uj  }(j  Kgj  Kuuj  }(j  }(j  KPj  Kuj  }(j  KPj  Kuuh}(h-file:///Users/jik/Desktop/backup-go/status.gohjW  h&/Users/jik/Desktop/backup-go/status.gohj  uh]h!Nu}(j  getLinuxServiceStatusj  func() (bool, int)j  Kj  }(j  }(j  Kjj  K uj  }(j  Kj  Kuuj  }(j  }(j  Kjj  Kuj  }(j  Kjj  Kuuh}(h-file:///Users/jik/Desktop/backup-go/status.gohjd  h&/Users/jik/Desktop/backup-go/status.gohj  uh]h!Nu}(j  getWindowsServiceStatusj  func() (bool, int)j  Kj  }(j  }(j  Kj  K uj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuh}(h-file:///Users/jik/Desktop/backup-go/status.gohjq  h&/Users/jik/Desktop/backup-go/status.gohj  uh]h!Nu}(j  getProcessStatusj  func() (bool, int)j  Kj  }(j  }(j  Kj  K uj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuh}(h-file:///Users/jik/Desktop/backup-go/status.gohj~  h&/Users/jik/Desktop/backup-go/status.gohj  uh]h!Nu}(j  getLastBackupInfoj  func() (time.Time, bool)j  Kj  }(j  }(j  Kj  K uj  }(j  Mj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuh}(h-file:///Users/jik/Desktop/backup-go/status.gohj  h&/Users/jik/Desktop/backup-go/status.gohj  uh]h!Nu}(j  extractTimestampFromLogj  func(logLine string) stringj  Kj  }(j  }(j  Mj  K uj  }(j  Mj  Kuuj  }(j  }(j  Mj  Kuj  }(j  Mj  Kuuh}(h-file:///Users/jik/Desktop/backup-go/status.gohj  h&/Users/jik/Desktop/backup-go/status.gohj  uh]h!Nu}(j  getServiceStatusTextj  !func(status ServiceStatus) stringj  Kj  }(j  }(j  Mj  K uj  }(j  Mj  Kuuj  }(j  }(j  Mj  Kuj  }(j  Mj  Kuuh}(h-file:///Users/jik/Desktop/backup-go/status.gohj  h&/Users/jik/Desktop/backup-go/status.gohj  uh]h!Nu}(j  getBackupStatusTextj  func(success bool) stringj  Kj  }(j  }(j  M"j  K uj  }(j  M'j  Kuuj  }(j  }(j  M"j  Kuj  }(j  M"j  Kuuh}(h-file:///Users/jik/Desktop/backup-go/status.gohj  h&/Users/jik/Desktop/backup-go/status.gohj  uh]h!Nu}(j  showDetailedStatusj  func()j  Kj  }(j  }(j  M*j  K uj  }(j  MYj  Kuuj  }(j  }(j  M*j  Kuj  }(j  M*j  Kuuh}(h-file:///Users/jik/Desktop/backup-go/status.gohj  h&/Users/jik/Desktop/backup-go/status.gohj  uh]h!Nu}(j  showStorageInfoj  func()j  Kj  }(j  }(j  M\j  K uj  }(j  Mwj  Kuuj  }(j  }(j  M\j  Kuj  }(j  M\j  Kuuh}(h-file:///Users/jik/Desktop/backup-go/status.gohj  h&/Users/jik/Desktop/backup-go/status.gohj  uh]h!Nu}(j  getCurrentExecutablePathj  
func() stringj  Kj  }(j  }(j  Mzj  K uj  }(j  Mj  Kuuj  }(j  }(j  Mzj  Kuj  }(j  Mzj  Kuuh}(h-file:///Users/jik/Desktop/backup-go/status.gohj  h&/Users/jik/Desktop/backup-go/status.gohj  uh]h!Nu}(j  getCurrentWorkingDirj  
func() stringj  Kj  }(j  }(j  Mj  K uj  }(j  Mj  Kuuj  }(j  }(j  Mj  Kuj  }(j  Mj  Kuuh}(h-file:///Users/jik/Desktop/backup-go/status.gohj  h&/Users/jik/Desktop/backup-go/status.gohj  uh]h!Nu}(j  formatBytesj  func(bytes int64) stringj  Kj  }(j  }(j  Mj  K uj  }(j  Mj  Kuuj  }(j  }(j  Mj  Kuj  }(j  Mj  Kuuh}(h-file:///Users/jik/Desktop/backup-go/status.gohj  h&/Users/jik/Desktop/backup-go/status.gohj  uh]h!Nue](j  j:  jG  jT  ja  jn  j{  j  j  j  j  j  j  j  j  j  eu.