#!/bin/bash
set -e

echo "======================================"
echo "  ClashMac Helper Uninstall Script"
echo "======================================"
echo ""

if [ "$EUID" -ne 0 ]; then
  echo "Error: Please run with sudo: sudo ./uninstall-helper.sh"
  exit 1
fi

PLIST_PATH="/Library/LaunchDaemons/com.clashmac.helper.plist"
HELPER_PATH="/Library/PrivilegedHelperTools/com.clashmac.helper"
SOCKET_PATH="/var/run/com.clashmac.helper.sock"
LOG_PATH="/var/log/com.clashmac.helper.log"

launchctl unload "$PLIST_PATH" 2>/dev/null || true
rm -f "$PLIST_PATH"
rm -f "$HELPER_PATH"
rm -f "$SOCKET_PATH"
rm -f "$LOG_PATH"

HELPER_LOG_DIR="/Users/Shared/clashmac/logs"
if [ -d "$HELPER_LOG_DIR" ]; then
  rm -f "$HELPER_LOG_DIR/helper.log" "$HELPER_LOG_DIR/helper.log.old"
  echo "Helper logs cleared"
fi

KERNEL_SOCKET="/tmp/clashmac.sock"
if [ -S "$KERNEL_SOCKET" ]; then
  rm -f "$KERNEL_SOCKET"
fi

pkill -f "mihomo" || true

echo "Helper uninstalled"
