#!/bin/bash
set -e

echo "======================================"
echo "  ClashMac Helper Install Script"
echo "======================================"
echo ""

if [ "$EUID" -ne 0 ]; then
  echo "Error: Please run with sudo: sudo ./install-helper.sh"
  exit 1
fi

SCRIPT_DIR="$(cd "$(dirname "$0")" && pwd)"

if [ -f "$SCRIPT_DIR/com.clashmac.helper" ]; then
  HELPER_BINARY="$SCRIPT_DIR/com.clashmac.helper"
elif [ -f "$SCRIPT_DIR/../ClashMacHelper/com.clashmac.helper" ]; then
  HELPER_BINARY="$SCRIPT_DIR/../ClashMacHelper/com.clashmac.helper"
else
  HELPER_BINARY="$SCRIPT_DIR/com.clashmac.helper"
fi

if [ -f "$SCRIPT_DIR/com.clashmac.helper.plist" ]; then
  PLIST_SOURCE="$SCRIPT_DIR/com.clashmac.helper.plist"
else
  PLIST_SOURCE="$SCRIPT_DIR/../scripts/com.clashmac.helper.plist"
fi

INSTALL_PATH="/Library/PrivilegedHelperTools/com.clashmac.helper"
PLIST_INSTALL="/Library/LaunchDaemons/com.clashmac.helper.plist"

echo "Script directory: $SCRIPT_DIR"
echo "Helper source: $HELPER_BINARY"
echo ""

if [ ! -f "$HELPER_BINARY" ]; then
  echo "Error: Helper not found: $HELPER_BINARY"
  exit 1
fi

if [ ! -f "$PLIST_SOURCE" ]; then
  echo "Error: Plist not found: $PLIST_SOURCE"
  exit 1
fi

if [ -f "$PLIST_INSTALL" ]; then
  launchctl unload "$PLIST_INSTALL" 2>/dev/null || true
  rm -f "$PLIST_INSTALL"
  rm -f "$INSTALL_PATH"
  rm -f /var/run/com.clashmac.helper.sock
fi

HELPER_LOG_DIR="/Users/Shared/clashmac/logs"
if [ -d "$HELPER_LOG_DIR" ]; then
  rm -f "$HELPER_LOG_DIR/helper.log" "$HELPER_LOG_DIR/helper.log.old"
  echo "Old helper logs cleared"
fi

mkdir -p /Library/PrivilegedHelperTools/
cp "$HELPER_BINARY" "$INSTALL_PATH"
chmod 755 "$INSTALL_PATH"
chown root:wheel "$INSTALL_PATH"

cp "$PLIST_SOURCE" "$PLIST_INSTALL"
chmod 644 "$PLIST_INSTALL"
chown root:wheel "$PLIST_INSTALL"

launchctl load -w "$PLIST_INSTALL"
sleep 1

if launchctl list | grep -q com.clashmac.helper; then
  echo "Helper installed and running"
else
  echo "Helper installed but not running, check logs"
fi
