#!/bin/sh
set -e

# 创建 app 目录结构
mkdir -p /app/www /app/conf.d /app/rewrite

# 检查是否需要初始化
INIT_NEEDED=false

if [ -z "$(ls -A /app/www 2>/dev/null)" ]; then
    echo "📦 初始化网站代码..."
    cp -r /opt/default-app/www/. /app/www/
    INIT_NEEDED=true
fi

if [ -z "$(ls -A /app/rewrite 2>/dev/null)" ]; then
    echo "📦 初始化伪静态规则..."
    cp -r /opt/default-app/rewrite/. /app/rewrite/
    INIT_NEEDED=true
fi

if [ -z "$(ls -A /app/conf.d 2>/dev/null)" ]; then
    echo "📦 初始化虚拟主机配置..."
    cp -r /opt/default-app/conf.d/. /app/conf.d/
    INIT_NEEDED=true
fi

# 如果没有进行初始化，静默跳过
if [ "$INIT_NEEDED" = false ]; then
    # 静默跳过，不输出任何信息
    :
fi

# 设置权限
chown -R nginx:nginx /app

# 启动 PHP-FPM（通用命令）
php-fpm -D

# 启动 Nginx
nginx -g "daemon off;"