# CLAUDE.md

This file provides guidance to Claude Code (claude.ai/code) when working with code in this repository.

## 项目概述

基于 Docker 的 Nginx + PHP 8.3 开发环境，统一挂载设计，配置实时生效。

## 常用命令

```bash
# 构建镜像
docker build -t nginx-php:8.3 .

# 启动开发环境
docker-compose up -d

# 重新构建并启动
docker-compose up --build -d

# 停止服务
docker-compose down

# 查看日志
docker-compose logs -f

# 进入容器
docker-compose exec nginx-php sh
```

- 访问地址：http://localhost:9080

## 项目结构

统一使用 `app/` 目录挂载，包含所有配置和代码：

```
app/
├── www/          # PHP 文件目录（原 wwwroot/）
├── conf.d/       # Nginx 虚拟主机配置（原 nginx/conf.d/）
└── rewrite/      # Nginx 伪静态规则（原 nginx/rewrite/）
```

## 快速配置

- **PHP 文件**：放置在 `app/www/` 目录
- **Nginx 配置**：修改 `app/conf.d/default.conf`
- **伪静态规则**：修改 `app/rewrite/default.conf`
- **端口修改**：在 `compose.yml` 中修改 `9080:80`

## 技术栈

- PHP 8.3 (FPM) + Nginx
- 已安装扩展：gd, curl, pdo_mysql, zip, redis
- 基础镜像：Alpine Linux